% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmdd.R
\name{pmdd}
\alias{pmdd}
\title{Partial Martingale Difference Divergence}
\usage{
pmdd(X, Y, Z)
}
\arguments{
\item{X}{A vector, matrix or data frame, where rows represent samples, and columns represent variables.}

\item{Y}{A vector, matrix or data frame, where rows represent samples, and columns represent variables.}

\item{Z}{A vector, matrix or data frame, where rows represent samples, and columns represent variables.}
}
\value{
\code{pmdd} returns the value of squared partial martingale difference divergence.
}
\description{
\code{pmdd} measures conditional mean dependence of \code{Y} given \code{X} conditioning on \code{Z},
where each contains one variable (univariate) or more variables (multivariate).
}
\examples{
# X, Y, Z are vectors with 10 samples and 1 variable
X <- rnorm(10)
Y <- rnorm(10)
Z <- rnorm(10)

pmdd(X, Y, Z)

# X, Y, Z are 10 x 2 matrices with 10 samples and 2 variables
X <- matrix(rnorm(10 * 2), 10, 2)
Y <- matrix(rnorm(10 * 2), 10, 2)
Z <- matrix(rnorm(10 * 2), 10, 2)

pmdd(X, Y, Z)
}
\references{
Park, T., Shao, X., and Yao, S. (2015).
  Partial martingale difference correlation.
  Electronic Journal of Statistics, 9(1), 1492-1517.
  \url{http://dx.doi.org/10.1214/15-EJS1047}.
}
