% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_event_subscription.R
\name{get_event_subscription}
\alias{get_event_subscription}
\title{Get event subscription}
\usage{
get_event_subscription(subscriptionId, as = "data.frame", env = "production")
}
\arguments{
\item{subscriptionId}{(numeric) Event subscription identifier}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) Subscription metadata
}
\description{
Get event subscription
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Get subscription
subscription <- get_event_subscription(
  subscriptionId = 21,
  env = "staging"
)

logout()
}

}
\seealso{
Other Event Notifications: 
\code{\link{create_event_subscription}()},
\code{\link{delete_event_subscription}()},
\code{\link{execute_event_subscription}()},
\code{\link{get_event_subscription_schema}()},
\code{\link{query_event_subscriptions}()}
}
\concept{Event Notifications}
