% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_event_subscription.R
\name{create_event_subscription}
\alias{create_event_subscription}
\title{Create event subscription}
\usage{
create_event_subscription(packageId, url, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{url}{(character) Where the event notification will be sent}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(numeric) Event subscription identifier
}
\description{
Create event subscription
}
\note{
User authentication is required (see \code{login()})

The \code{url} must have "http" as its scheme and must be able to receive
POST requests with MIME type text/plain. Additionally, because the
\code{url} will be passed in an XML body, some characters must be escaped,
such as ampersands from & to &amp;.
}
\examples{
\dontrun{

login()

# Create subscription
subscriptionId <- create_event_subscription(
  packageId = "knb-lter-vcr.340.1",
  url = "https://my.webserver.org/",
  env = "staging"
)
subscriptionId
#> [1] 48

# Execute subscription
execute_event_subscription(subscriptionId, env = "staging")
#> [1] TRUE

# Delete subscription
delete_event_subscription(subscriptionId, env = "staging")
#> [1] TRUE

logout()
}

}
\seealso{
Other Event Notifications: 
\code{\link{delete_event_subscription}()},
\code{\link{execute_event_subscription}()},
\code{\link{get_event_subscription_schema}()},
\code{\link{get_event_subscription}()},
\code{\link{query_event_subscriptions}()}
}
\concept{Event Notifications}
