EBelasticNet.Gaussian <-
function(BASIS,Target,lambda,alpha,verbose = 0 ){
	N 				= nrow(BASIS);
	K 				= ncol(BASIS);
	Epis = FALSE;
	if (verbose>0) cat("Empirical Bayes Elastic Net Gaussian Model \n");
	if(!Epis){
		N_effect 		= K;
		Beta 			= rep(0,N_effect *4);

		output<-.C("elasticNetLinear",
			BASIS 	= as.double(BASIS),
			Target 	= as.double(Target),
			lamda 	= as.double(lambda),
			alpha 	= as.double(alpha),
			Beta 		= as.double(Beta),
			WaldScore 	= as.double(0),
			Intercept 	= as.double(0),
			N 		= as.integer(N),
			K 		= as.integer(K),
			verbose = as.integer(verbose),
			residual = as.double(0),
			PACKAGE="EBglmnet");

	}		
#-------------------------------------------------------------------

	result 			= matrix(output$Beta,N_effect,4);
	ToKeep 			= which(result[,3]!=0);

	if(length(ToKeep)==0) { Blup = matrix(0,1,4)
	}else
	{
		nEff 	= length(ToKeep);
		Blup 		= result[ToKeep,,drop=FALSE];
	}
	
	#t-test:
	Blup 			= Blup[,1:4,drop = FALSE]; 			#will not report 5th column of Epis model;
	t 				= abs(Blup[,3])/(sqrt(Blup[,4])+ 1e-20);
pvalue 			= 2*(1- pt(t,df=(N-1)));
	blup 			= cbind(Blup[,2:4, drop = FALSE],t,pvalue); 			#M x 5
	colnames(blup) = c("predictor","beta","posterior variance","t-value","p-value");	
	
	hyperparameters = c(alpha, lambda);
	fEBresult 			<- list(blup,output$WaldScore,output$Intercept,output$residual,hyperparameters);
	rm(list= "output")	
	names(fEBresult)		<-c("fit","WaldScore","Intercept","residual variance","hyperparameters")
	return(fEBresult)
	
}
