% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document-data.R
\docType{data}
\name{calibrationSample}
\alias{calibrationSample}
\alias{testSample}
\title{Sample data Insurgency Predictions}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 696 rows and 4 columns.

An object of class \code{matrix} (inherits from \code{array}) with 348 rows and 4 columns.
}
\usage{
calibrationSample

testSample
}
\description{
This includes the data for the predictions of insurgencies in 29 countries for 2010.
}
\details{
The predictions included in the dataset are:
\itemize{
\item\code{LMER} Predictions from a generalized linear mixed effects model using a logistic link function and including a randomeffects term for lagged GDP per capita and the lagged number of conflictual events involving the United States in the country of interest. 
\item\code{SAE} Predictions from a one model developed as part of the ICEWS project and was designed by Strategic Analysis Enterprises.
\item\code{GLM} Predictions from a crude logistic model that includes only population size, GDP growth (both lagged 3 months), the number of minority groups at risk in the country, and a measure of anocracy supplied in the Polity IV data set.
}
More detail about each model can be found in Mongomery et al. (2012)
}
\examples{
\dontrun{
data(calibrationSample)
data(testSample)

this.ForecastData <- makeForecastData(.predCalibration=calibrationSample[,c("LMER", "SAE", "GLM")],
.outcomeCalibration=calibrationSample[,"Insurgency"],.predTest=testSample[,c("LMER", "SAE", "GLM")],
.outcomeTest=testSample[,"Insurgency"], .modelNames=c("LMER", "SAE", "GLM"))
initW <- rep(1/3,3)

this.ensemble.em <- calibrateEnsemble(this.ForecastData, model="logit", tol=0.001)

this.ensemble.gibbs <- calibrateEnsemble(this.ForecastData, model="logit", method = "gibbs")
}

}
\references{
Montgomery, Jacob M., Florian M. Hollenbach and Michael D. Ward. (2012). Improving Predictions Using Ensemble Bayesian Model Averaging.  \emph{Political Analysis}. \bold{20}: 271-291.
}
\keyword{datasets}
