\docType{data}
\name{calibrationSample}
\alias{calibrationSample}
\title{Exemplar calibration sample data}
\description{
  This includes the calibration sample data for the
  insurgency forecasting example in Montgomery, Hollenbach
  and Ward (2012). It provides the predictions for the
  three models included in the Ensemble model, as well as
  the true values of the dependent variable for insurgency
  in 29 Asian countries. The calibration sample ranges from
  January 2008 to December 2009.
}
\details{
  The variables included in the dataset are: \itemize{
  \item\code{LMER} The calibration sample predictions of
  the LMER model from the insurgency prediction example in
  Montgomery et. al. (2012). The LMER model is a
  generalized linear mixed effects model using the logistic
  link function. It includes two random effects terms and
  several other covariates. \item\code{SAE} The calibration
  sample prediction of the SAE model from the insurgency
  prediction example in Montgomery et. al. (2012). This is
  a model developed as part of the ICEWS project and was
  designed by \emph{Strategic Analysis Enterprises}. It is
  a simple generalized linear model with 27 independent
  variables. \item\code{GLM} The calibration sample
  prediction of the GLM model from the insurgency
  prediction example in Montgomery et. al. (2012). This is
  a crude logistic model with only four independent
  variables. \item\code{Insurgency} The true values of the
  dependent variable in the calibration sample from the
  insurgency prediction example in Montgomery et. al.
  (2012). This is a binary variable indicating the actual
  ocurrence of insurgency for each observation in the
  calibration sample. }
}
\references{
  Montgomery, Jacob M., Florian M. Hollenbach and Michael
  D. Ward. (2012). Improving Predictions Using Ensemble
  Bayesian Model Averaging. \emph{Political Analysis}.
  \bold{20}: 271-291.
}
\keyword{datasets}

