% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVPI.R
\docType{class}
\name{EVPI_DECREASE}
\alias{EVPI_DECREASE}
\title{A Reference Class to represent the EVPI}
\description{
An object that combines three others objects : object_inmb, object_pop, object_var_inmb.
}
\section{Fields}{

\describe{
\item{\code{object_inmb}}{: an instance that inherits the \link{INMB_DIRECT}}

\item{\code{object_var_inmb}}{: an instance that inherits the \link{VAR_INMB_DIRECT}}

\item{\code{object_pop}}{: an instance that inherits the \link{POP}}

\item{\code{step_ref}}{(default=1) : to define the ratio (step_ref/step_exp) for group allocation during the study}

\item{\code{step_exp}}{(default=1) : to define the ratio (step_ref/step_exp) for group allocation during the study}
}}
\section{Methods}{

 \describe{
 \item{get_N():}{return the estimated optimal sample size for the study}
 \item{get_N_exp():}{return the estimated number of individuals in the experimental group}
 \item{get_N_ref():}{return the estimated number of participants to include in the reference group}
 \item{get_k(N_exp):}{return the ratio (step_ref/step_exp) for group allocation}
 \item{set_N_ref(N_ref):}{sets the number of individuals in the reference group (N_exp will be automatically calculated according to the ratio)}
 \item{set_N_exp(N_exp):}{sets the number of individuals in the experimental group (N_ref will be automatically calculated according to the ratio)}
 \item{set_object_inmb(object_inmb):}{sets object_inmb for this EVPI_DECREASE object}
 \item{set_object_var_inmb(object_var_inmb):}{sets object_var_inmb for this EVPI_DECREASE object}
 \item{set_object_pop(object_pop):}{sets object_pop for this EVPI_DECREASE object}
 }
}

