% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DysGPS.R
\name{DysGPS}
\alias{DysGPS}
\title{Calculates Dysregulated gene pair score (DysGPS) for each gene pair.}
\usage{
DysGPS(
  dataset,
  class.labels,
  controlcharacter,
  casecharacter,
  edgesbackground = combined_background
)
}
\arguments{
\item{dataset}{Matrix of gene expression values (rownames are genes, columnnames are samples).}

\item{class.labels}{Vector of category labels.}

\item{controlcharacter}{Charactor of control group in the class labels.}

\item{casecharacter}{Charactor of case group in the class labels.}

\item{edgesbackground}{Matrix of the gene pairs' background. The default is `combined_background`,
which includes real pathway gene pairs and randomly producted gene pairs. The 'combined_background' was incluede in 'DysPIAData'.}
}
\value{
A vector of DysGPS for each gene pair.
}
\description{
two-sample Welch's T test of gene pairs between case and control samples. The package 'DysPIAData' including the background data is needed to be loaded.
}
\examples{
data(gene_expression_p53, class.labels_p53,sample_background)
DysGPS_sample<-DysGPS(gene_expression_p53, class.labels_p53,
 "WT", "MUT", sample_background)

}
