% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransToAPIM.R
\name{TransToAPIM}
\alias{TransToAPIM}
\title{TransToAPIM}
\usage{
TransToAPIM(M)
}
\arguments{
\item{M}{a transition matrix which should be converted to APIM like beta-coefficients}
}
\value{
B0_1 Intercept if the first sequence is the dependent variable

AE_1 Actor-Effect if the first sequence is the dependent variable

PE_1 Partner-Effect if the first sequence is the dependent variable

Int_1 Actor*Partner-Intercation-Effect if the first sequence is the dependent variable

B0_2 Intercept if the second sequence is the dependent variable

AE_2 Actor-Effect if the second sequence is the dependent variable

PE_2 Partner-Effect if the second sequence is the dependent variable

Int_2 Actor*Partner-Intercation-Effect if the second sequence is the dependent variable
}
\description{
Transforms a transition matrix into equivalent APIM beta-coefficients. 
(only implemented for binary dyadic sequences!)
}
\examples{


test<-matrix(c(0.41 , 0.28 , 0.19 , 0.12,
              0.18 , 0.18 , 0.32 , 0.32,
              0.18 , 0.22 , 0.27 , 0.33,
              0.05 , 0.09 , 0.30 , 0.55) , 4 , 4 , byrow = TRUE)

x<-TransToAPIM(test)
# inspecting the beta-coefficients
x

#backtesting (last row will show minor errors caused by rounding)
round(APIMtoTrans(x[1],x[2],x[3],x[4],x[5],x[6],x[7],x[8]),2)

}
