% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableDoseCoverage}
\alias{tableDoseCoverage}
\title{Format a dose_coverage object into a visual table.}
\usage{
tableDoseCoverage(
  result,
  header = c("variable", "estimate"),
  splitStrata = TRUE,
  ingridientName = TRUE,
  cdmName = TRUE,
  groupColumn = NULL,
  type = "gt",
  formatEstimateName = c(`N (\%)` = "<count_missing> (<percentage_missing> \%)", N =
    "<count>", `Mean (SD)` = "<mean> (<sd>)", `Median (Q25 - Q75)` =
    "<median> (<q25> - <q75>)"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object with results from
summariseDoseCoverage().}

\item{header}{A vector containing which elements should go into the header
in order. Allowed are: \code{cdm_name}, \code{group}, \code{strata}, \code{variable}, and
\code{estimate}.}

\item{splitStrata}{If TRUE strata columns will be split.}

\item{ingridientName}{If TRUE cohort names will be displayed.}

\item{cdmName}{If TRUE database names will be displayed.}

\item{groupColumn}{Column to use as group labels.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{formatEstimateName}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{.options}{Named list with additional formatting options.
DrugUtilisation::defaultTableOptions() shows allowed
arguments and their default values.}
}
\value{
A table with a formatted version of summariseDrugCoverage() results.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

result <- summariseDoseCoverage(cdm, 1125315)

tableDoseCoverage(result)
}

}
