% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableDrugRestart}
\alias{tableDrugRestart}
\title{Format a drug_restart object into a visual table.}
\usage{
tableDrugRestart(
  result,
  header = c("strata"),
  splitStrata = TRUE,
  cohortName = TRUE,
  cdmName = TRUE,
  groupColumn = c("cdm_name", "cohort_name"),
  type = "gt",
  formatEstimateName = c(`N (\%)` = "<count> (<percentage> \%)"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object with results from
summariseDrugRestart().}

\item{header}{A vector containing which elements should go into the header
in order. Allowed values: \code{cdm_name}, \code{cohort_name}, \code{strata}, \code{variable},
\code{estimate}.}

\item{splitStrata}{If TRUE strata columns will be split.}

\item{cohortName}{If TRUE cohort names will be displayed.}

\item{cdmName}{If TRUE database names will be displayed.}

\item{groupColumn}{Column to use as group labels. Allowed values: \code{cdm_name},
\code{cohort_name}, \code{strata}, \code{variable_name}, \code{variable_level}, \code{estimate_name}.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{formatEstimateName}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{.options}{Named list with additional formatting options.
DrugUtilisation::defaultTableOptions() shows allowed arguments and their
default values.}
}
\value{
A table with a formatted version of summariseDrugRestart() results.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

conceptlist <- list("a" = 1125360, "b" = c(1503297, 1503327))
cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "switch_cohort",
  conceptSet = conceptlist
)

result <- cdm$cohort1 |>
  summariseDrugRestart(switchCohortTable = "switch_cohort")

tableDrugRestart(result)

CDMConnector::cdmDisconnect(cdm = cdm)
}

}
