% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkDUS.R
\name{benchmarkDUS}
\alias{benchmarkDUS}
\title{Run benchmark of drug utilisation cohort generation}
\usage{
benchmarkDUS(
  cdm,
  numberOfCohort = 1:4,
  indicationCohortName = "cohort1",
  ingredientId = 1125315,
  drugExposureName = "drug_exposure"
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{numberOfCohort}{Number of cohort to generate for benchmarking. An integer or a vector of integers}

\item{indicationCohortName}{Name of indication cohort table}

\item{ingredientId}{Ingredient OMOP concept that we are interested for
the study. It is a compulsory input, no default value is provided.}

\item{drugExposureName}{Name of drug_exposure table in cdm, the table must contain drug_concept_id, quantity,
drug_exposure_start_date and drug_exposure_end_date as columns}
}
\value{
a tibble with time taken for different analyses
}
\description{
Run benchmark of drug utilisation cohort generation
}
\examples{
\donttest{
cdm <- DrugUtilisation::mockDrugUtilisation()
timings <- DrugUtilisation::benchmarkDUS(cdm)
}
}
