% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseIndication.R
\name{summariseIndication}
\alias{summariseIndication}
\title{This function is used to summarise the indication table over multiple
cohorts.}
\usage{
summariseIndication(
  cohort,
  cdm,
  strata = list(),
  indicationVariables = indicationColumns(cohort),
  minCellCount = 1
)
}
\arguments{
\item{cohort}{Cohort with indications and strata}

\item{cdm}{cdm_reference created by CDMConnector}

\item{strata}{Stratification list}

\item{indicationVariables}{Variables that point to an indication column}

\item{minCellCount}{Minimum counts that a group can have. Cohorts with
less counts than this value are obscured. By default: 5.}
}
\value{
A Tibble with 4 columns: cohort_definition_id, variable, estimate and
value. There will be one row for each cohort, variable and cohort
combination.
}
\description{
This function is used to summarise the indication table over multiple
cohorts.
}
\examples{
\donttest{
library(DrugUtilisation)
library(PatientProfiles)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()
indications <- list("headache" = 378253, "asthma" = 317009)
cdm <- generateConceptCohortSet(cdm, "indication_cohorts", indications)
acetaminophen <- getDrugIngredientCodes(cdm, "acetaminophen")
cdm <- generateDrugUtilisationCohortSet(cdm, "drug_cohort", acetaminophen)
cdm$drug_cohort <- cdm$drug_cohort \%>\%
  addIndication(cdm, "indication_cohorts", indicationGap = c(0, 30, 365))

summariseIndication(cdm$drug_cohort, cdm)

cdm$drug_cohort <- cdm$drug_cohort \%>\%
  addAge(cdm, ageGroup = list("<40" = c(0, 39), ">=40" = c(40, 150))) \%>\%
  addSex(cdm)

summariseIndication(cdm$drug_cohort, cdm, strata = list(
  "Age" = "age_group", "Age & Sex" = c("age_group", "sex")
))
}

}
