% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VariousFunctions.R
\name{SeedSelection}
\alias{SeedSelection}
\title{SeedSelection}
\usage{
SeedSelection(features, num_clusters, s)
}
\arguments{
\item{features}{train matrix of features (in the case of k-folding is the matrix of features)}

\item{num_clusters}{number of clusters desired}

\item{s}{the list of seeds}
}
\value{
Seed subset of the feature matrix, where rows are the Seed drugs, and columns the relative features
}
\description{
Given the seeds, it creates the submatrix of the features where the rows are just the seeds drugs
}
\examples{
r <- 8
c <- 10
m0 <- matrix(0, r, c)
num_clusters=4
features<-apply(m0, c(1,2), function(x) sample(c(0,1),1))
s<-RandomSeedGenerator(num_clusters,nrow(features))
Seed<-SeedSelection(features,num_clusters,s)
}

