% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoFeature.R
\name{generateFeature}
\alias{generateFeature}
\title{Automated column transformer}
\usage{
generateFeature(data, varlist, type = "Frequent", method = NULL)
}
\arguments{
\item{data}{dataframe or data.table}

\item{varlist}{variable list to generate the additional features}

\item{type}{variable transformation type 'Dummy','Outlier','Frequent', 'Interaction'}

\item{method}{input for variabe transforamtion. For type = 'Frequent' then type should be 'Frequency' or 'Percent'. Other type method list is provided in details}
}
\value{
generated transformed features
}
\description{
This function automatically scans through each variable and generate features based on the type listed in the detail
}
\details{
This function is for generating features based on diffenret transformation methods like interaction, outliers, Dummy coding etc.

Interaction type
\itemize{
  \item multiply - multipliaction
  \item add - addition
  \item substract - substraction
  \item divide - division
}
Frequency type
\itemize{
  \item Frequency - Frequency
  \item Percent - Percentage
}
Outlier type
\itemize{
  \item Flag - Falg outlier values like 1 or 0
  \item Capping - Impute outlier value by 95th or 5th percentile value
}
Date type
\itemize{
  \item Year
  \item Month
  \item Quarter
  \item Week
}
}
\examples{
# Generate interaction features
generateFeature(heart, varlist = c("cp", "chol", "trestbps"), type = "Interaction",
method = "add")
generateFeature(heart, varlist = c("cp", "chol", "trestbps"), type = "Interaction",
method = "multiply")

# Generate frequency features
generateFeature(heart, varlist = c("cp", "thal"), type = "Frequent", method = "Percent")
generateFeature(heart, varlist = c("cp", "thal"), type = "Frequent", method = "Frequency")

}
