% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaryStatistics.R, R/frequencytable.R
\name{filterByDictionary}
\alias{filterByDictionary}
\alias{frequencytable}
\title{Word frequencies}
\usage{
filterByDictionary(
  ft,
  fields = DramaAnalysis::base_dictionary[fieldnames],
  fieldnames = c("Liebe")
)

frequencytable(
  drama,
  acceptedPOS = postags$de$words,
  column = "Token.lemma",
  byCharacter = FALSE,
  sep = "|",
  normalize = FALSE,
  sortResult = FALSE,
  segment = c("Drama", "Act", "Scene")
)
}
\arguments{
\item{ft}{A matrix as produced by \code{frequencytable()}.}

\item{fields}{A list of lists that contains the actual field names. 
By default, we load the base_dictionary (as in \code{dictionaryStatistics()}).}

\item{fieldnames}{A list of names for the dictionaries.}

\item{drama}{A \code{QDDrama}. May be covering multiple texts.}

\item{acceptedPOS}{A list of accepted pos tags. Words of all POS tags not in this list 
are filtered out. Specify NULL or an empty list to include all words.}

\item{column}{The column name we should use (should be either Token.surface or Token.lemma)}

\item{byCharacter}{Logical. Whether the count is by character or by text.}

\item{sep}{The separation symbol that goes between drama name and character (if applicable). 
Defaults to the pipe symbol.}

\item{normalize}{Whether to normalize values or not. If set to TRUE, the values are normalized by
row sums.}

\item{sortResult}{Logical. If true, the columns with the highest sum are ordered left (i.e., frequent words are visible first). If false, the columns are ordered alphabetically by column name.}

\item{segment}{Character vector. Whether the count is by drama (default), act or scene}
}
\value{
Matrix of word frequencies in the format words X segments
}
\description{
The function \code{filterByDictionary()} can be used to filter a matrix as produced by 
\code{frequencytable()} by the words in the given dictionary(/-ies).

The function \code{frequencytable()} generates a matrix of word frequencies 
by drama, act or scene and/or by character. The output of this function can be fed to stylo.
}
\examples{
data(rksp.0)
ftable <- frequencytable(rksp.0, 
                         byCharacter = TRUE)
                                              
filtered <- filterByDictionary(ftable, 
                               fieldnames=c("Krieg", "Familie"))

data(rksp.0)
st <- frequencytable(rksp.0)
\donttest{
stylo(gui=FALSE, frequencies = st)
}
}
\seealso{
\code{stylo}
}
