% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{protein_data}
\alias{protein_data}
\title{Protein data}
\format{
\describe{
  \item{groupA}{ER+ data; data.frame: first two columns contain protein identifiers ref_seq and gene_name;
                other columns are samples containing the quantified proteomics data per protein}
  \item{groupB}{ER- data; data.frame: first two columns contain protein identifiers ref_seq and gene_name;
                other columns are samples containing the quantified proteomics data per protein}
}
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and Targeted
Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
protein_data
}
\description{
Protein analysis of breast cancer patients data from Krug et al. (2020) (data from the Clinical
Proteomic Tumor Analysis Consortium (CPTAC)). The data is stratified by estrogen receptor (ER)
expression status (`groupA` = ER+, `groupB` = ER-). The data was reduced to 50 genes.
For each group a data frame is given containing the raw data with the proteins as rows and the
samples as columns. The first two columns contain the protein identifiers
(ref_seq and gene_name).
}
\keyword{datasets}
