% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LogtESDFPerc.R
\name{LogtESDFPerc}
\alias{LogtESDFPerc}
\title{Percentiles of ES distribution function for Student-t}
\usage{
LogtESDFPerc(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
standard deviation data. Accordingly, number of input arguments is either 6
or 8. In case there 6 input arguments, the mean and standard deviation of
data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 n Sample size

 investment Size of investment

 perc Desired percentile

 df Number of degrees of freedom in the t distribution

 cl ES confidence level and must be a scalar

 hp ES holding period and must be a a scalar}
}
\value{
Percentiles of ES distribution function
}
\description{
Plots the ES of a portfolio against confidence level assuming that geometric returns are
Student t distributed, for specified confidence level and holding period.
}
\examples{
# Estimates Percentiles of ES distribution
   data <- runif(5, min = 0, max = .2)
   LogtESDFPerc(returns = data, investment = 5, perc = .7, df = 6, cl = .95, hp = 60)

   # Computes v given mean and standard deviation of return data
   LogtESDFPerc(mu = .012, sigma = .03, n= 10, investment = 5, perc = .8, df = 6, cl = .99, hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

