% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GumbelES.R
\name{GumbelES}
\alias{GumbelES}
\title{Gumbel ES}
\usage{
GumbelES(mu, sigma, n, cl, hp)
}
\arguments{
\item{mu}{Location parameter for daily L/P}

\item{sigma}{Assumed scale parameter for daily L/P}

\item{n}{Assumed block size from which the maxima are drawn}

\item{cl}{VaR confidence level}

\item{hp}{VaR holding period}
}
\value{
Estimated ES. If cl and hp are scalars, it returns scalar VaR. If cl
is vector and hp is a scalar, or viceversa, returns vector of VaRs. If both
cl and hp are vectors, returns a matrix of VaRs.
}
\description{
Estimates the ES of a portfolio assuming extreme losses are
Gumbel distributed, for specified confidence level and holding period.
Note that the long-right-hand tail is fitted to losses, not profits.
}
\examples{
# Gumber ES Plot
   GumbelES(0, 1.2, 100, c(.9,.88, .85, .8), 280)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

National Institute of Standards and Technology, Dataplot Reference Manual.
Volume 1: Commands. NIST: Washington, DC, 1997, p. 8-67.
}

