% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CdfOfSumUsingGumbelCopula.R
\name{CdfOfSumUsingGumbelCopula}
\alias{CdfOfSumUsingGumbelCopula}
\title{Derives prob ( X + Y < quantile) using Gumbel copula}
\usage{
CdfOfSumUsingGumbelCopula(quantile, mu1, mu2, sigma1, sigma2, beta)
}
\arguments{
\item{quantile}{Portfolio quantile (or negative of Var, if X, Y are position P/Ls)}

\item{mu1}{Mean of Profit/Loss on first position}

\item{mu2}{Mean of Profit/Loss on second position}

\item{sigma1}{Standard Deviation of Profit/Loss on first position}

\item{sigma2}{Standard Deviation of Profit/Loss on second position}

\item{beta}{Gumber copula parameter (greater than 1)}
}
\value{
Probability of X + Y being less than quantile
}
\description{
If X and Y are position P/Ls, then the VaR is equal to minus quantile. In
such cases, we insert the negative of the VaR as the quantile, and the
function gives us the value of 1 minus VaR confidence level. In other
words, if X and Y are position P/Ls, the quantile is the negative of the
VaR, and the output is 1 minus the VaR confidence level.
}
\examples{
# Prob ( X + Y < q ) using Gumbel Copula for X with mean 2.3 and std. .2
   # and Y with mean 4.5 and std. 1.5 with beta 1.2 at 0.9 quantile
   CdfOfSumUsingGumbelCopula(0.9, 2.3, 4.5, 1.2, 1.5, 1.2)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Dowd, K. and Fackler, P. Estimating VaR with copulas. Financial Engineering
News, 2004.
}

