% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BlancoIhleBacktest.R
\name{BlancoIhleBacktest}
\alias{BlancoIhleBacktest}
\title{Blanco-Ihle forecast evaluation backtest measure}
\usage{
BlancoIhleBacktest(Ra, Rb, Rc, cl)
}
\arguments{
\item{Ra}{Vector of a portfolio profit and loss}

\item{Rb}{Vector of corresponding VaR forecasts}

\item{Rc}{Vector of corresponding Expected Tailed Loss forecasts}

\item{cl}{VaR confidence interval}
}
\value{
First Blanco-Ihle score measure.
}
\description{
Derives the Blanco-Ihle forecast evaluation loss measure for a VaR
risk measurement model.
}
\examples{
# Blanco-Ihle Backtest For Independence for given confidence level.
   # The VaR and ES are randomly generated.
   a <- rnorm(1*100)
   b <- abs(rnorm(1*100))+2
   c <- abs(rnorm(1*100))+2
   BlancoIhleBacktest(a, b, c, 0.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, Kevin. Measuring Market Risk, Wiley, 2007.

Blanco, C. and Ihle, G. How Good is Your Var? Using Backtesting to Assess
System Performance. Financial Engineering News, 1999.
}

