% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AmericanPutVaRBinomial.R
\name{AmericanPutVaRBinomial}
\alias{AmericanPutVaRBinomial}
\title{Estimates VaR of American vanilla put using binomial tree.}
\usage{
AmericanPutVaRBinomial(amountInvested, stockPrice, strike, r, volatility,
  maturity, numberSteps, cl, hp)
}
\arguments{
\item{amountInvested}{Total amount paid for the Put Option.}

\item{stockPrice}{Stock price of underlying stock.}

\item{strike}{Strike price of the option.}

\item{r}{Risk-free rate.}

\item{volatility}{Volatility of the underlying stock.}

\item{maturity}{Time to maturity of the option in days.}

\item{numberSteps}{The number of time-steps considered for
the binomial model.}

\item{cl}{Confidence level for which VaR is computed.}

\item{hp}{Holding period of the option in days.}
}
\value{
VaR of the American Put Option
}
\description{
Estimates VaR of American Put Option using binomial tree to price the option
and historical method to compute the VaR.
}
\examples{
# Market Risk of American Put with given parameters.
   AmericanPutVaRBinomial(0.20, 27.2, 25, .16, .05, 60, 20, .95, 30)
}
\author{
Dinesh Acharya
}
\references{
Dowd, Kevin. Measuring Market Risk, Wiley, 2007.

Lyuu, Yuh-Dauh. Financial Engineering & Computation: Principles,
Mathematics, Algorithms, Cambridge University Press, 2002.
}

