% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R
\name{configWorkerContainerEnv}
\alias{configWorkerContainerEnv}
\title{Configurate the worker container environment}
\usage{
configWorkerContainerEnv(container, cluster, workerNumber, verbose)
}
\arguments{
\item{container}{Reference Container Object. The worker container.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{workerNumber}{Integer. The number of workers in a container.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
An object which has the same class as \code{container}
}
\description{
Configurate the worker container environment. Developers can use this function
to set the server Ip, password and etc. via the container environment variable.
The server info can be found by the getter function with the prefix \code{.getServer}
(e.g. \code{.getServerPassword(cluster)}). Depending on the network status, the worker
can use the server private IP to connect with the server.
The developer \emph{must} calls \code{container$copy()} before
setting the server environment. The user provided environment variables should
be respected and overwritten only when necessary.
There is no default method for this generic.
}
