% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiversityOccu.R
\name{occupancy.predict}
\alias{occupancy.predict}
\title{Predicts occupancy for all the species in a batchoccupancy class object}
\usage{
occupancy.predict(batch, new.data)
}
\arguments{
\item{batch}{A result from the batchoccu}

\item{new.data}{a rasterstack, or a dataframe containing the same variables as
the siteCovs variable in batchoccu}
}
\value{
a raster stack with predictions
for each species.
}
\description{
This function takes an batchoccupancy object and predicts occupancy for all species
in new data, either a data.frame or a rasterstack.
}
\examples{
\dontrun{
#Load the data
data("IslandBirds")
data("Daily_Cov")
data("siteCov")
data("Birdstack")
BirdOccupancy <-batchoccu(pres = IslandBirds, sitecov = siteCov, obscov =
Daily_Cov, spp =  5, form = ~ Day + Wind + Rime + Noise + Clouds ~
Elev + AgroFo + SecVec + Wetland)

Occupancy.stack <- occupancy.predict(batch = BirdOccupancy, new.data =
Birdstack)
}
}
\seealso{
\code{\link[DiversityOccupancy]{batchoccu}}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
