% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotfunctions.R
\name{responseplot.abund}
\alias{responseplot.abund}
\title{plot the response of an abundance model to the change of aparticular variable}
\usage{
responseplot.abund(batch, spp, variable)
}
\arguments{
\item{batch}{A result from the diversityoccu function.}

\item{spp}{The species number of which response is going to be ploted.}

\item{variable}{The variable of which the response is to be ploted.}
}
\value{
a ggplot object plotting the alpha diversity response to the selected
variable.
}
\description{
This function takes a diversityoccupancy object and one of the variables used
to predict abundance, and makes a plot showing the response of occupancyt
against the selected variable. This function automatically limits the values
of that variable to the maximum and minimum values of the dataset.
}
\examples{
\dontrun{
data("IslandBirds")
data("Daily_Cov")
data("siteCov")

#Model the abundance for 5 bird species and calculate alpha diversity from that

BirdDiversity <-diversityoccu(pres = IslandBirds, sitecov = siteCov,
obscov = Daily_Cov,spp = 5, form = ~ Day + Wind + Time + Rain +
Noise ~ Elev + AgroFo + SecVec + Wetland + Upland)

#plot the response of abundance to individual variables for species 4, 11

responseplot.abund(batch = BirdDiversity, spp = 4, variable = Elev)

responseplot.abund(batch = BirdDiversity, spp = 11, variable = Elev)
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
\seealso{
\code{\link[DiversityOccupancy]{batchoccu}}
}

