% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotfunctions.R
\name{responseplot.diver}
\alias{responseplot.diver}
\title{plot the response of the calculated alpha diversity to the change of a
particular variable}
\usage{
responseplot.diver(model, variable)
}
\arguments{
\item{model}{A result from the model.diversity function.}

\item{variable}{The variable of which the response is to be ploted.}
}
\value{
a ggplot object plotting the alpha diversity response to the selected
variable.
}
\description{
This function takes a modeldiversity object and one of the variables used to
predict the alpha diversity index, and makes a plot showing the response of
the diversity index against the selected variable. This function automatically
limits the values of that variable to the maximum and minimum values of the
dataset.
}
\examples{
\dontrun{
data("BatOccu")
data("Dailycov")
data("sampling.cov")
BatDiv <-diversityoccu(pres = BatOccu, sitecov = sampling.cov, obscov =
Dailycov,spp = 17, form = ~ Julian + Meanhum + Meantemp + sdhum +
sdtemp ~ Burn.intensity.soil + I(Burn.intensity.soil^2) +
Burn.intensity.Canopy + I(Burn.intensity.Canopy^2) + Burn.intensity.basal +
I(Burn.intensity.basal^2))

#Select the best model that explains diversity using genetic algorithms
set.seed(123)
glm.Batdiversity <- model.diversity(BatDiv, method = "g")

#see the best models

glm.Batdiversity$Best.model

#plot the response of diversity to individual variables

responseplot.diver(glm.Batdiversity, Burn.intensity.soil)
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
\seealso{
\code{\link[DiversityOccupancy]{diversityoccu}}

\code{\link[DiversityOccupancy]{model.diversity}}
}

