#' Occupancy data of 17 bat species.
#'
#' A dataset containing the detections and non detections of 17 species in the
#' Plumas County (Columns) for 3 consecutive days in 49 different sites (Rows).
#'
#' @format A data frame with 49 rows and 51 variables:
#' \describe{
#'   \item{Myyu1}{Detection (1) or non-detection (0), of \emph{Myotis yumanensis}:
#'    on day 1}
#'   \item{Myyu2}{Detection (1) or non-detection (0), of \emph{Myotis yumanensis}:
#'    on day 2}
#'   \item{Myyu3}{Detection (1) or non-detection (0), of \emph{Myotis yumanensis}:
#'    on day 3}
#'   \item{Myca1}{Detection (1) or non-detection (0), of \emph{Myotis californicus}:
#'    on day 1}
#'   \item{Myca2}{Detection (1) or non-detection (0), of \emph{Myotis californicus}:
#'    on day 2}
#'   \item{Myca3}{Detection (1) or non-detection (0), of \emph{Myotis californicus}:
#'    on day 3}
#'   \item{Myci1}{Detection (1) or non-detection (0), of \emph{Myotis ciliolabrum}:
#'    on day 1}
#'   \item{Myci2}{Detection (1) or non-detection (0), of \emph{Myotis ciliolabrum}:
#'    on day 2}
#'   \item{Myci3}{Detection (1) or non-detection (0), of \emph{Myotis ciliolabrum}:
#'    on day 3}
#'   \item{Myvo1}{Detection (1) or non-detection (0), of \emph{Myotis volans}:
#'    on day 1}
#'   \item{Myvo2}{Detection (1) or non-detection (0), of \emph{Myotis volans}:
#'    on day 2}
#'   \item{Myvo3}{Detection (1) or non-detection (0), of \emph{Myotis volans}:
#'    on day 3}
#'   \item{Mylu1}{Detection (1) or non-detection (0), of \emph{Myotis lucifugus}:
#'    on day 1}
#'   \item{Mylu2}{Detection (1) or non-detection (0), of \emph{Myotis lucifugus}:
#'    on day 2}
#'   \item{Mylu3}{Detection (1) or non-detection (0), of \emph{Myotis lucifugus}:
#'    on day 3}
#'   \item{Pahe1}{Detection (1) or non-detection (0), of \emph{Parastrellus hesperus}:
#'    on day 1}
#'   \item{Pahe2}{Detection (1) or non-detection (0), of \emph{Parastrellus hesperus}:
#'    on day 2}
#'   \item{Pahe3}{Detection (1) or non-detection (0), of \emph{Parastrellus hesperus}:
#'    on day 3}
#'   \item{Labl1}{Detection (1) or non-detection (0), of \emph{Lasiurus blossevillii}:
#'    on day 1}
#'   \item{Labl2}{Detection (1) or non-detection (0), of \emph{Lasiurus blossevillii}:
#'    on day 2}
#'   \item{Labl3}{Detection (1) or non-detection (0), of \emph{Lasiurus blossevillii}:
#'    on day 3}
#'   \item{Myev1}{Detection (1) or non-detection (0), of \emph{Myotis evotis}:
#'    on day 1}
#'   \item{Myev2}{Detection (1) or non-detection (0), of \emph{Myotis evotis}:
#'    on day 2}
#'   \item{Myev3}{Detection (1) or non-detection (0), of \emph{Myotis evotis}:
#'    on day 3}
#'   \item{Anpa1}{Detection (1) or non-detection (0), of \emph{Antrozous pallidus}:
#'    on day 1}
#'   \item{Anpa2}{Detection (1) or non-detection (0), of \emph{Antrozous pallidus}:
#'    on day 2}
#'   \item{Anpa3}{Detection (1) or non-detection (0), of \emph{Antrozous pallidus}:
#'    on day 3}
#'   \item{Epfu1}{Detection (1) or non-detection (0), of \emph{Eptesicus fuscus}:
#'    on day 1}
#'   \item{Epfu2}{Detection (1) or non-detection (0), of \emph{Eptesicus fuscus}:
#'    on day 2}
#'   \item{Epfu3}{Detection (1) or non-detection (0), of \emph{Eptesicus fuscus}:
#'    on day 3}
#'   \item{Lano1}{Detection (1) or non-detection (0), of \emph{Lasionycteris noctivagans}:
#'    on day 1}
#'   \item{Lano2}{Detection (1) or non-detection (0), of \emph{Lasionycteris noctivagans}:
#'    on day 2}
#'   \item{Lano3}{Detection (1) or non-detection (0), of \emph{Lasionycteris noctivagans}:
#'    on day 3}
#'   \item{Myth1}{Detection (1) or non-detection (0), of \emph{Myotis thysanodes}:
#'    on day 1}
#'   \item{Myth2}{Detection (1) or non-detection (0), of \emph{Myotis thysanodes}:
#'    on day 2}
#'   \item{Myth3}{Detection (1) or non-detection (0), of \emph{Myotis thysanodes}:
#'    on day 3}
#'   \item{Tabr1}{Detection (1) or non-detection (0), of \emph{Tadarida brasiliensis}:
#'    on day 1}
#'   \item{Tabr2}{Detection (1) or non-detection (0), of \emph{Tadarida brasiliensis}:
#'    on day 2}
#'   \item{Tabr3}{Detection (1) or non-detection (0), of \emph{Tadarida brasiliensis}:
#'    on day 3}
#'   \item{Laci1}{Detection (1) or non-detection (0), of \emph{Lasiurus cinereus}:
#'    on day 1}
#'   \item{Laci2}{Detection (1) or non-detection (0), of \emph{Lasiurus cinereus}:
#'    on day 2}
#'   \item{Laci3}{Detection (1) or non-detection (0), of \emph{Lasiurus cinereus}:
#'    on day 3}
#'   \item{Coto1}{Detection (1) or non-detection (0), of \emph{Corynorhinus townsendii}:
#'    on day 1}
#'   \item{Coto2}{Detection (1) or non-detection (0), of \emph{Corynorhinus townsendii}:
#'    on day 2}
#'   \item{Coto3}{Detection (1) or non-detection (0), of \emph{Corynorhinus townsendii}:
#'    on day 3}
#'   \item{Euma1}{Detection (1) or non-detection (0), of \emph{Euderma maculatum}:
#'    on day 1}
#'   \item{Euma2}{Detection (1) or non-detection (0), of \emph{Euderma maculatum}:
#'    on day 2}
#'   \item{Euma3}{Detection (1) or non-detection (0), of \emph{Euderma maculatum}:
#'    on day 3}
#'   \item{Eupe1}{Detection (1) or non-detection (0), of \emph{Eumops perotis}:
#'    on day 1}
#'   \item{Eupe2}{Detection (1) or non-detection (0), of \emph{Eumops perotis}:
#'    on day 2}
#'   \item{Eupe3}{Detection (1) or non-detection (0), of \emph{Eumops perotis}:
#'    on day 3}
#' }
"BatOccu"


#' Occupancy data of 13 bird species in Micronesia.
#'
#' A dataset containing the detections history of 13 species in the
#' Pohnpei Island for 4 consecutive days (Columns) in 120 different sites (Rows).
#' \describe{
#'   \item{CICA.1}{Detection history of \emph{Coracina tenurostris}: on day 1}
#'   \item{CICA.2}{Detection history of \emph{Coracina tenurostris}: on day 2}
#'   \item{CICA.3}{Detection history of \emph{Coracina tenurostris}: on day 3}
#'   \item{CICA.4}{Detection history of \emph{Coracina tenurostris}: on day 4}
#'   \item{CIRW.1}{Detection history of \emph{Acrocephalus syrinx}: on day 1}
#'   \item{CIRW.2}{Detection history of \emph{Acrocephalus syrinx}: on day 2}
#'   \item{CIRW.3}{Detection history of \emph{Acrocephalus syrinx}: on day 3}
#'   \item{CIRW.4}{Detection history of \emph{Acrocephalus syrinx}: on day 4}
#'   \item{CIWE.1}{Detection history of \emph{Zosterops semperi}: on day 1}
#'   \item{CIWE.2}{Detection history of \emph{Zosterops semperi}: on day 2}
#'   \item{CIWE.3}{Detection history of \emph{Zosterops semperi}: on day 3}
#'   \item{CIWE.4}{Detection history of \emph{Zosterops semperi}: on day 4}
#'   \item{GRWE.1}{Detection history of \emph{Zosterops cinereus}: on day 1}
#'   \item{GRWE.2}{Detection history of \emph{Zosterops cinereus}: on day 2}
#'   \item{GRWE.3}{Detection history of \emph{Zosterops cinereus}: on day 3}
#'   \item{GRWE.4}{Detection history of \emph{Zosterops cinereus}: on day 4}
#'   \item{LBWE.1}{Detection history of \emph{Rukia longirostra}: on day 1}
#'   \item{LBWE.2}{Detection history of \emph{Rukia longirostra}: on day 2}
#'   \item{LBWE.3}{Detection history of \emph{Rukia longirostra}: on day 3}
#'   \item{LBWE.4}{Detection history of \emph{Rukia longirostra}: on day 4}
#'   \item{MIHO.1}{Detection history of \emph{Myzomela rubratra}: on day 1}
#'   \item{MIHO.2}{Detection history of \emph{Myzomela rubratra}: on day 2}
#'   \item{MIHO.3}{Detection history of \emph{Myzomela rubratra}: on day 3}
#'   \item{MIHO.4}{Detection history of \emph{Myzomela rubratra}: on day 4}
#'   \item{MIKI.1}{Detection history of \emph{Toridamphus reichenbachii}: on
#'   day 1}
#'   \item{MIKI.2}{Detection history of \emph{Toridamphus reichenbachii}: on
#'   day 2}
#'   \item{MIKI.3}{Detection history of \emph{Toridamphus reichenbachii}: on
#'   day 3}
#'   \item{MIKI.4}{Detection history of \emph{Toridamphus reichenbachii}: on
#'   day 4}
#'   \item{MIPI.1}{Detection history of \emph{Ducula oceanica}: on day 1}
#'   \item{MIPI.2}{Detection history of \emph{Ducula oceanica}: on day 2}
#'   \item{MIPI.3}{Detection history of \emph{Ducula oceanica}: on day 3}
#'   \item{MIPI.4}{Detection history of \emph{Ducula oceanica}: on day 4}
#'   \item{MIST.1}{Detection history of \emph{Aplonis opaca}: on day 1}
#'   \item{MIST.2}{Detection history of \emph{Aplonis opaca}: on day 2}
#'   \item{MIST.3}{Detection history of \emph{Aplonis opaca}: on day 3}
#'   \item{MIST.4}{Detection history of \emph{Aplonis opaca}: on day 4}
#'   \item{PCFD.1}{Detection history of \emph{Ptilinopus porphyraceu}: on day 1}
#'   \item{PCFD.2}{Detection history of \emph{Ptilinopus porphyraceu}: on day 2}
#'   \item{PCFD.3}{Detection history of \emph{Ptilinopus porphyraceu}: on day 3}
#'   \item{PCFD.4}{Detection history of \emph{Ptilinopus porphyraceu}: on day 4}
#'   \item{POFA.1}{Detection history of \emph{Rhipidura kubaryi}: on day 1}
#'   \item{POFA.2}{Detection history of \emph{Rhipidura kubaryi}: on day 2}
#'   \item{POFA.3}{Detection history of \emph{Rhipidura kubaryi}: on day 3}
#'   \item{POFA.4}{Detection history of \emph{Rhipidura kubaryi}: on day 4}
#'   \item{POFL.1}{Detection history of \emph{Myigra pluto}: on day 1}
#'   \item{POFL.2}{Detection history of \emph{Myigra pluto}: on day 2}
#'   \item{POFL.3}{Detection history of \emph{Myigra pluto}: on day 3}
#'   \item{POFL.4}{Detection history of \emph{Myigra pluto}: on day 4}
#'   \item{POLO.1}{Detection history of \emph{Trichoglosuss rbiginosus}: on
#'   day 1}
#'   \item{POLO.2}{Detection history of \emph{Trichoglosuss rbiginosus}: on
#'   day 2}
#'   \item{POLO.3}{Detection history of \emph{Trichoglosuss rbiginosus}: on
#'   day 3}
#'   \item{POLO.4}{Detection history of \emph{Trichoglosuss rbiginosus}: on
#'   day 4}
#' }
#' @format A data frame with 120 rows and 52 variables
#' @seealso \code{\link[DiversityOccupancy]{Daily_Cov}}
#' @seealso \code{\link[DiversityOccupancy]{siteCov}}
#' @references Oleiro P. 2014. Avian population responses to anthropogenic
#' landscape changes in Pohnpei, Federated Stats of Micronesia. Masters Thesis
#' University of Missouri.
"IslandBirds"

#' Nine covariables measured at 120 survey stations in an island in micronesia
#'
#' A dataframe containing the measurements of 9 variables (columns) correspondant
#' to 120 different survey stations (Rows) in Pohnpei Island where the detection
#' histories of the IslandBirds where taken.
#' \describe{
#'   \item{Elev}{Metres above sea level of the sampled point}
#'   \item{Patches}{the number of discrete habitat patches within a 50 m radius
#'   of the survey station}
#'   \item{PD}{XXXXXX}
#'   \item{DIVISION}{XXXXX}
#'   \item{RPR}{XXXXX}
#'   \item{AgroFo}{Proportion of a station (from 0 to 1) corresponding to
#'   agricultural forest incudes areas withsubsistence or commercial staple
#'   crops mixed with undisturbed forest}
#'   \item{SecVec}{Proportion of a station (from 0 to 1) corresponding to
#'   secondary vegetation which represents anthropogenic habitats (e.g.,
#'   savannah) and early colonizers and invasive species (e.g. \emph{Hibiscus spp.}
#'    and \emph{Merremia peltata)}}
#'   \item{Wetland}{Proportion of a station (from 0 to 1) corresponding to areas
#'   classified as mangroves, marshes, swamp forest and fresh water bodies}
#'   \item{Upland}{Proportion of a station (from 0 to 1) corresponding to upland
#'   and undisturbed forest habitats}
#' }
#' @format A data frame with 120 rows and 52 variables:
#' @seealso \code{\link[DiversityOccupancy]{Daily_Cov}}
#' @seealso \code{\link[DiversityOccupancy]{IslandBirds}}
#' @references Oleiro P. 2014. Avian population responses to anthropogenic
#' landscape changes in Pohnpei, Federated Stats of Micronesia. Masters Thesis
#' University of Missouri.

"siteCov"

#' Seven covariables measured at 120 survey stations in an island in micronesia
#'
#' A list containing the measurements of seven variables correspondant to 120
#' different survey stations (Rows) in Pohnpei Island where the detection
#' histories of the IslandBirds where taken.
#'
#' \describe{
#'   \item{Day}{Ordinal day}
#'   \item{Wind}{Wind intensity using a modified Beafourt scale}
#'   \item{Obs}{First initial of the observer}
#'   \item{Time}{Survey time (minutes after sunrise)}
#'   \item{Rain}{Categorical variable where 0 = no rain, 1 = light rain and
#'   2 = heavy rain}
#'   \item{Noise}{Ambient noise (1-10 being 10 the loudest)}
#'   \item{Clouds}{Cloud cover in percentage}
#' }
#' @format A list with 6 elements, each of them with a data frame
#' @seealso \code{\link[DiversityOccupancy]{IslandBirds}}
#' @seealso \code{\link[DiversityOccupancy]{siteCov}}
#' @references Oleiro P. 2014. Avian population responses to anthropogenic
#' landscape changes in Pohnpei, Federated Stats of Micronesia. Masters Thesis
#' University of Missouri.

"Daily_Cov"

#' Eight covariables measured at 49 survey stations in the Plumas National Forest
#'
#' A dataframe containing the measurements of 8 variables (columns) correspondant
#' to 49 different sampling sites (Rows) in the Plumas National Forest where the
#' detection histories of the BatOccu where taken.
#' \describe{
#'   \item{Distance.to.water}{Distance to the closest water source measured in
#'   meters}
#'   \item{Distance.to.road}{Distance to the closest road measured in meters}
#'   \item{Existing.vegetation}{Numeric code to vegetation type}
#'   \item{Fire.Interval}{Average interval between wildfires, measured in years}
#'   \item{Altitude}{Metres above sea level of the sampled point}
#'   \item{Burn.intensity.soil}{This data set reflects fire intensity as
#'   measured by soil scorched in a scale from 0 to 5}
#'   \item{Burn.intensity.Canopy}{This data set reflects fire intensity as
#'   measured by canopy scorched in a scale from 0 to 6}
#'   \item{Burn.intensity.basal}{This data set reflects fire intensity as
#'   measured by tree tunks scorched in a scale from 0 to 8}
#' }
#' @format A data frame with 49 rows and 8 variables:
#' @seealso \code{\link[DiversityOccupancy]{Dailycov}}
#' @seealso \code{\link[DiversityOccupancy]{BatOccu}}

"sampling.cov"

#' Nine covariables measured at 49 sampling points in Plumas National Forest, Ca
#'
#' A list containing the measurements of nine variables correspondant to 49
#' different sampling sites (Rows) in Plumas National Forest where the detection
#' histories of the BatOccu dataset where taken.
#'
#' \describe{
#'   \item{Julian}{Ordinal day}
#'   \item{Maxhum}{Maximum humidity measured on that day}
#'   \item{Maxtemp}{Maximum temperature meassured on that day}
#'   \item{Meanhum}{Average humidity meassured on that day}
#'   \item{Meantemp}{Average temperature meassured on that day}
#'   \item{Mimhum}{Minimum humidity measured on that day}
#'   \item{Mintemp}{Minimum temperature meassured on that day}
#'   \item{sdhum}{Standard deviation of the humidity meassured on that day}
#'   \item{sdtemp}{Standard devuatuib of the temperature meassured on that day}
#' }
#' @format A list with 9 elements, each of them with a data frame
#' @seealso \code{\link[DiversityOccupancy]{BatOccu}}
#' @seealso \code{\link[DiversityOccupancy]{plumas.stack}}
#' @seealso \code{\link[DiversityOccupancy]{sampling.cov}}

"Dailycov"

#' Raster Stack with eight variables measured in the Plumas National Forest
#'
#' A Raster Stack containing eight rasters from in the Plumas National Forest
#' where the detection histories of the BatOccu where taken.
#' \describe{
#'   \item{Distance.to.water}{Distance to the closest water source measured in
#'   meters}
#'   \item{Distance.to.road}{Distance to the closest road measured in meters}
#'   \item{Existing.vegetation}{Numeric code to vegetation type}
#'   \item{Fire.Interval}{Average interval between wildfires, measured in years}
#'   \item{Altitude}{Metres above sea level of the sampled point}
#'   \item{Burn.intensity.soil}{This data set reflects fire intensity as
#'   measured by soil scorched in a scale from 0 to 5}
#'   \item{Burn.intensity.Canopy}{This data set reflects fire intensity as
#'   measured by canopy scorched in a scale from 0 to 6}
#'   \item{Burn.intensity.basal}{This data set reflects fire intensity as
#'   measured by tree tunks scorched in a scale from 0 to 8}
#' }
#' @format A data frame with 49 rows and 8 variables:
#' @seealso \code{\link[DiversityOccupancy]{BatOccu}}
#' @seealso \code{\link[DiversityOccupancy]{Dailycov}}
#' @seealso \code{\link[DiversityOccupancy]{sampling.cov}}

"plumas.stack"
