% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mexcess_unif.R
\name{Mexcess_unif}
\alias{Mexcess_unif}
\title{Mean excess loss of the Uniform distribution}
\usage{
Mexcess_unif(d, min = 0, max = 1)
}
\arguments{
\item{d}{cut-off value.}

\item{min, max}{lower and upper limits of the distribution. Must be finite.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{E_unif}}}{ gives the expected value.}
 \item{\code{\link{V_unif}}}{ gives the variance.}
 \item{\code{\link{kthmoment_unif}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_unif}}}{ gives the truncated mean.}
 \item{\code{\link{SL_unif}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_unif}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_unif}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_unif}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_unif}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Mean excess loss of the Uniform distribution
 with min \eqn{a} and max \eqn{b}.
}
\details{
The (continuous) uniform distribution with min and max parameters \eqn{a}
  and \eqn{b} respectively has density:
  \deqn{f(x) = \frac{1}{b - a} \times \bm{1}_{\{x \in [a, b] \}}}{f(x) = 1 / (b - a) x 1_\{a <= x <= b\}}
  for \eqn{x \in [a, b]}{a <= x <= b}.
}
\examples{

Mexcess_unif(d = 2, min = 2, max = 4)

}
\seealso{
Other Continuous Uniform Distribution: 
\code{\link{E_unif}()},
\code{\link{Elim_unif}()},
\code{\link{Etronq_unif}()},
\code{\link{SL_unif}()},
\code{\link{TVaR_unif}()},
\code{\link{V_unif}()},
\code{\link{VaR_unif}()},
\code{\link{kthmoment_unif}()}
}
\concept{Continuous Uniform Distribution}
