% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Elim_weibull.R
\name{Elim_weibull}
\alias{Elim_weibull}
\title{Limited mean of the Weibull distribution}
\usage{
Elim_weibull(d, shape, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{d}{cut-off value.}

\item{shape}{shape parameter \eqn{\tau}{tau}, must be positive integer.}

\item{rate}{\eqn{\beta}{beta} is the rate parameter, must be positive.}

\item{scale}{alternative parameterization to rate parameter, scale = 1 / rate.}
}
\value{
Returns numeric value.
 Function :
 \itemize{
 \item{\code{\link{E_weibull}}}{ gives the expected value.}
 \item{\code{\link{V_weibull}}}{ gives the variance.}
 \item{\code{\link{kthmoment_weibull}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_weibull}}}{ gives the truncated mean.}
 \item{\code{\link{SL_weibull}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_weibull}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_weibull}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_weibull}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_weibull}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Limited mean of the Weibull distribution with shape
 parameter \eqn{\tau}{tau} and rate parameter \eqn{\beta}{beta}.
}
\details{
The Weibull distribution with shape parameter \eqn{\tau}{t} and rate parameter
  \eqn{\beta}{b} has density:
  \deqn{f\left(x\right) = \beta \tau \left( \beta x \right) ^{\tau -1} %
   \mathrm{e}^{-\left( \beta x\right) ^{\tau }}}{f(x) = b t (b x)^(t - 1) %
   e^{(-b x)^t}}
  for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\beta > 0}{b > 0}, \eqn{\tau > 0}{t > 0}
}
\examples{

# With scale parameter
Elim_weibull(d = 2, shape = 2, scale = 5)

# With rate parameter
Elim_weibull(d = 2, shape = 2, rate = 0.2)

}
\seealso{
Other Weibull Distribution: 
\code{\link{E_weibull}()},
\code{\link{Etronq_weibull}()},
\code{\link{Mexcess_weibull}()},
\code{\link{SL_weibull}()},
\code{\link{TVaR_weibull}()},
\code{\link{V_weibull}()},
\code{\link{VaR_weibull}()},
\code{\link{kthmoment_weibull}()}
}
\concept{Weibull Distribution}
