% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aux_fun.R
\name{short.eff}
\alias{short.eff}
\title{Shortcuts for critical values computation}
\usage{
short.eff(sorted.num, t)
}
\arguments{
\item{sorted.num}{a numeric vector in increasing order.}

\item{t}{the threshold, a number between 0 and 1.}
}
\value{
A subvector of \code{sorted.num}.
}
\description{
Extracts all values from a sorted vector
that are greater than or equal to the effective
critical value associated to a threshold.
}
\details{
The effective critical value associated to \code{t} is
the largest value of \code{sorted.num} that is less than 
or equal to \code{t}.

This version: 2018-02-12.
}
\examples{
x<-c(0.1,0.2,0.3,0.4)
short.eff(x,0.2)
short.eff(x,0.35)

}
