% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_node_df.R
\name{add_node_df}
\alias{add_node_df}
\title{Add nodes from a node data frame to an existing graph object}
\usage{
add_node_df(graph, node_df)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_df}{A node data frame that is created using \code{\link[=create_node_df]{create_node_df()}}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph} add nodes from a node data frame to
that graph.
}
\examples{
# Create an empty graph
graph <- create_graph()

# Create a node data frame (ndf)
ndf <-
  create_node_df(n = 2)

# Add the node data frame to
# the graph object to create
# a graph with nodes
graph <-
  graph \%>\%
  add_node_df(
    node_df = ndf)

# Inspect the graph's ndf
graph \%>\% get_node_df()

# Create another ndf
ndf_2 <-
  create_node_df(n = 3)

# Add the second node data
# frame to the graph object
# to add more nodes with
# attributes to the graph
graph <-
  graph \%>\%
  add_node_df(
    node_df = ndf_2)

# View the graph's internal
# node data frame using the
# `get_node_df()` function
graph \%>\% get_node_df()

}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{add_node}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_nodes_ws}()},
\code{\link{delete_node}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
