% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_min_cut_between.R
\name{get_min_cut_between}
\alias{get_min_cut_between}
\title{Get the minimum cut between source and sink nodes}
\usage{
get_min_cut_between(graph, from, to)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{from}{the node ID for the source node.}

\item{to}{the node ID for the sink or target node.}
}
\value{
a single numeric value representing the
minimum total edge capacity removed to disconnect
the source and sink nodes.
}
\description{
Get the minimum cut between source
and sink nodes. This is the minimum total capacity
of edges needed for removal in order to eliminate
all paths from the source and sink nodes.
}
\examples{
# Set a seed
set.seed(23)

# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Determine the minimum cut
# between nodes `1` and `4`
graph \%>\%
  get_min_cut_between(
    from = 1,
    to = 2)

# Create a cycle graph with
# randomized values given to all
# edges as the `capacity` attribute
graph_capacity <-
  create_graph() \%>\%
  add_cycle(n = 5) \%>\%
  select_edges() \%>\%
  set_edge_attrs_ws(
    edge_attr = capacity,
    value =
      rnorm(
        n = count_edges(.),
        mean = 5,
        sd = 1)) \%>\%
  clear_selection()

# Determine the minimum cut
# between nodes `1` and `4` for
# this graph, where `capacity`is
# set as an edge attribute
graph_capacity \%>\%
  get_min_cut_between(
    from = 1,
    to = 2)

# Create a full graph and then
# get the minimum cut requirement
# between nodes `2` and `8`
create_graph() \%>\%
  add_full_graph(n = 10) \%>\%
  get_min_cut_between(
    from = 2,
    to = 8)
}
