% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_betweenness.R
\name{get_betweenness}
\alias{get_betweenness}
\title{Get betweenness centrality scores}
\usage{
get_betweenness(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame with betweenness scores for
each of the nodes.
}
\description{
Get the betweenness centrality scores
for all nodes in a graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the betweenness scores for nodes in the graph
get_betweenness(graph)
#>    id betweenness
#> 1   1         0.0
#> 2   2         0.0
#> 3   3         1.0
#> 4   4         0.0
#> 5   5         1.5
#> 6   6         7.5
#> 7   7         0.5
#> 8   8         0.0
#> 9   9         1.5
#> 10 10         0.0

# Add the betweenness values to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_betweenness(.))

# Display the graph's node data frame
get_node_df(graph)
#>    id type label value betweenness
#> 1   1 <NA>     1   6.0         0.0
#> 2   2 <NA>     2   2.5         0.0
#> 3   3 <NA>     3   3.5         1.0
#> 4   4 <NA>     4   7.5         0.0
#> 5   5 <NA>     5   8.5         1.5
#> 6   6 <NA>     6   4.5         7.5
#> 7   7 <NA>     7  10.0         0.5
#> 8   8 <NA>     8  10.0         0.0
#> 9   9 <NA>     9   8.5         1.5
#> 10 10 <NA>    10  10.0         0.0
}
