% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_attrs.R
\name{set_node_attrs}
\alias{set_node_attrs}
\title{Set node attributes}
\usage{
set_node_attrs(x, node_attr, values, nodes = NULL)
}
\arguments{
\item{x}{either a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}, or a node data frame.}

\item{node_attr}{the name of the attribute to set.}

\item{values}{the values to be set for the chosen
attribute for the chosen nodes.}

\item{nodes}{an optional vector of node IDs for
filtering the list of nodes present in the graph.}
}
\value{
either a graph object of class
\code{dgr_graph} or a node data frame, depending on
what type of object was supplied to \code{x}.
}
\description{
From a graph object of class
\code{dgr_graph} or a node data frame, set node
attribute properties for one or more nodes.
}
\examples{
# Create a node data frame (ndf)
nodes <-
  create_nodes(
    nodes = c("a", "b", "c", "d"),
    type = "letter",
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edges <-
  create_edges(
    from = c("a", "b", "c"),
    to = c("d", "c", "a"),
    rel = "leading_to")

# Create a graph
graph <-
  create_graph(
    nodes_df = nodes,
    edges_df = edges)

# Set attribute `color = "green"` for nodes `a`
# and `c` using the graph object
graph <-
  set_node_attrs(
    x = graph,
    node_attr = "color",
    values = "green",
    nodes = c("a", "c"))

# Set attribute `color = "green"`` for nodes `a`
# and `c` using the node data frame
nodes <-
  set_node_attrs(
    x = nodes,
    node_attr = "color",
    values = "green",
    nodes = c("a", "c"))

# Set attribute `color = "blue"` for all nodes
# the node data frame
nodes <-
  set_node_attrs(
    x = nodes,
    node_attr = "color",
    values = "blue")
}

