% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/delete_edge.R
\name{delete_edge}
\alias{delete_edge}
\title{Delete an edge from an existing graph object}
\usage{
delete_edge(graph, from, to)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph} that is created using \code{create_graph}.}

\item{from}{a node ID from which the edge to be removed is outgoing.}

\item{to}{a node ID to which the edge to be removed is incoming.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, delete an existing edge by specifying a pair of node IDs corresponding to the edge direction.
}
\examples{
\dontrun{
# Create an empty graph
graph <- create_graph()

# Add two nodes
graph <- add_node(graph, node = "a")
graph <- add_node(graph, node = "b")

# Add an edge
graph <- add_edges(graph, from = "a", to = "b")

# Delete the edge
graph <- delete_edge(graph, from = "a", to = "b")
}
}

