% Generated by roxygen2 (4.0.1): do not edit by hand
\name{depthEuclid}
\alias{depthEuclid}
\title{Euclidean Depth}
\usage{
depthEuclid(u, X, name = "X", ...)
}
\arguments{
\item{u}{Numerical vector or matrix whose depth is to be calculated. Dimension has to be the same as that of the observations.}

\item{X}{The data as a matrix, data frame or list. If it is a matrix or data frame, then each row is viewed as one multivariate observation. If it is a list, all components must be numerical vectors of equal length (coordinates of observations).}

\item{name}{name for this data set - it will be used on plots from depthproc.}

\item{\dots}{currently not supported.}
}
\description{
Computes the euclidean depth of a point or vectors of points with respect to a multivariate data set.
}
\details{
Calculation of Euclidean depth is exact.

 Returns the depth of multivariate point \code{u} with respect to data set \code{X}.
}
\examples{
x <- matrix(rnorm(9999), nc = 3)
 depthEuclid(x, x)
}
\author{
Daniel Kosiorowski, Mateusz Bocian, Anna Wegrzynkiewicz and Zygmunt Zawadzki from Cracow University of Economics.
}
\keyword{depth}
\keyword{function}
\keyword{multivariate}
\keyword{nonparametric}

