/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.models.GLMExplorer;
import org.rosuda.deducer.models.GLMExplorerPlots;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.models.LogisticBuilder;
import org.rosuda.deducer.models.LogisticDialog;
import org.rosuda.deducer.models.LogisticExplorerRoc;
import org.rosuda.deducer.models.LogisticModel;
import org.rosuda.deducer.models.ModelPlotPanel;

public class LogisticExplorer
extends GLMExplorer {
    LogisticExplorer(GLMModel gLMModel) {
        super(gLMModel);
        this.setTitle("Logistic Model Explorer");
        this.help.setUrl("pmwiki.php?n=Main.LogisticModel");
    }

    public void initTabs() {
        try {
            String string = "par(mfrow = c(2, 2),mar=c(5,4,2,2))\nhist(resid(" + this.pre.modelName + "),main=\"Residual\",xlab=\"Residuals\")\n" + "plot(" + this.pre.modelName + ",2,sub.caption=\"\")\n" + "plot(" + this.pre.modelName + ", c(4,5),sub.caption=\"\")";
            this.diagnosticTab = new ModelPlotPanel(string);
            this.tabs.addTab("Diagnostics", this.diagnosticTab);
            string = "par(mar=c(5,4,2,2))\ntry(cr.plots(" + this.pre.modelName + ",one.page=T,ask=F,identify.points=F,col=1),silent=TRUE)";
            this.termTab = new ModelPlotPanel(string);
            if (Deducer.rniEval("length(grep(\":\",c(attr(terms(" + this.pre.modelName + "),\"term.labels\"))))==0").asBool().isTRUE()) {
                this.tabs.addTab("Terms", this.termTab);
            }
            string = "par(mar=c(5,4,2,2))\ntry(av.plots(" + this.pre.modelName + ",one.page=T,ask=F,identify.points=F,col=1),silent=TRUE)";
            this.addedTab = new ModelPlotPanel(string);
            this.tabs.addTab("Added Variable", this.addedTab);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void updateClicked() {
        LogisticBuilder logisticBuilder = new LogisticBuilder(this.model);
        logisticBuilder.setLocationRelativeTo(this);
        logisticBuilder.setVisible(true);
        WindowTracker.addWindow(logisticBuilder);
        this.dispose();
    }

    public void plotsClicked() {
        JDialog jDialog;
        String string = (String)JOptionPane.showInputDialog(this.plots, "Please select the type of plot", "Plot Type", 3, null, new String[]{"Effect", "ROC"}, "Effect");
        if (string == null) {
            return;
        }
        if (string.equals("Effect")) {
            jDialog = new GLMExplorerPlots(this, this.model, this.pre);
            jDialog.setLocationRelativeTo(this);
            jDialog.setVisible(true);
        }
        if (string.equals("ROC")) {
            jDialog = new LogisticExplorerRoc(this, (LogisticModel)this.model);
            jDialog.setLocationRelativeTo(this.plots);
            jDialog.setVisible(true);
        }
        this.setModel(this.model);
    }

    public void run() {
        this.model.run(false, this.pre);
        this.dispose();
        LogisticDialog.setLastModel(this.model);
        Deducer.rniEval("rm('" + this.pre.data.split("\\$")[1] + "','" + this.pre.modelName.split("\\$")[1] + "',envir=" + Deducer.guiEnv + ")");
    }
}

