/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.plots.Aes;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.VariableSelector;

public class AesWidget
extends JPanel
implements ActionListener,
MouseListener {
    private IconButton addRemoveButton;
    private JTextField value;
    private JButton scale;
    private JButton colour;
    private Color colourValue;
    private JToggleButton toggleValue;
    private JToggleButton toggleVariable;
    private JComboBox variable;
    private JSlider slider;
    private Double sliderValue;
    private JComboBox options;
    private JLabel nameLab;
    private ComboBoxUI defaultComboBoxUI;
    private AesComboBoxEditor editor;
    private VariableSelector variableSelector;
    private boolean showToggle = true;
    private Color neededItemBackground = Color.decode("#fff3f6");
    private static String iconRoot = "";
    private DefaultComboBoxModel statVarModel;
    public static Vector lineOptions;
    public static Vector shapeOptions;
    private Aes model;
    private Component valueComponent;
    private FocusListener valueValidator = new ValueValidator();
    private AesTransferHandler transferHandler;
    static /* synthetic */ Class class$java$util$ArrayList;

    public AesWidget() {
        if (lineOptions == null) {
            this.initLineOptions();
        }
        if (shapeOptions == null) {
            this.initShapeOptions();
        }
        this.initGUI();
    }

    public AesWidget(Aes aes, VariableSelector variableSelector) {
        this();
        this.setVariableSelector(this.variableSelector);
        this.setModel(aes);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(200, 70));
            this.scale = new JButton();
            this.add((Component)this.scale, new AnchorConstraint(32, 961, 764, 860, 2, 0, 0, 1));
            this.scale.setPreferredSize(new Dimension(22, 22));
            this.scale.addActionListener(this);
            this.scale.setToolTipText("Edit scale");
            this.scale.setVisible(false);
            this.value = new JTextField();
            this.add((Component)this.value, new AnchorConstraint(450, 667, 764, 356, 1, 1, 0, 1));
            this.value.setPreferredSize(new Dimension(77, 22));
            this.colour = new JButton();
            this.add((Component)this.colour, new AnchorConstraint(450, 647, 764, 264, 1, 0, 1, 1));
            this.colour.setText("Set colour");
            this.colour.setPreferredSize(new Dimension(95, 22));
            this.colour.addActionListener(this);
            this.toggleValue = new JToggleButton();
            this.add((Component)this.toggleValue, new AnchorConstraint(13, 24, 376, 731, 2, 2, 0, 0));
            this.toggleValue.setPreferredSize(new Dimension(19, 13));
            this.toggleValue.setToolTipText("Use a specific value");
            this.toggleValue.addActionListener(this);
            this.toggleVariable = new JToggleButton();
            this.add((Component)this.toggleVariable, new AnchorConstraint(13, 5, 401, 852, 2, 2, 0, 0));
            this.toggleVariable.setPreferredSize(new Dimension(19, 13));
            this.toggleVariable.setToolTipText("Define by a variable");
            this.toggleVariable.addActionListener(this);
            this.nameLab = new JLabel("aes");
            this.add((Component)this.nameLab, new AnchorConstraint(13, 860, 472, 56, 2, 1, 0, 2));
            this.nameLab.setPreferredSize(new Dimension(60, 13));
            this.statVarModel = new DefaultComboBoxModel();
            this.editor = new AesComboBoxEditor();
            this.variable = new JComboBox();
            this.add((Component)this.variable, new AnchorConstraint(32, 50, 472, 56, 2, 2, 0, 2));
            this.variable.setModel(this.statVarModel);
            this.variable.setPreferredSize(new Dimension(196, 22));
            this.variable.setEditable(true);
            this.variable.setEditor(this.editor);
            SoftBevelBorder softBevelBorder = new SoftBevelBorder(1);
            this.editor.setBorder(softBevelBorder);
            this.variable.addMouseListener(this);
            this.editor.addMouseListener(this);
            this.variable.addActionListener(this);
            this.defaultComboBoxUI = this.variable.getUI();
            if (this.transferHandler == null) {
                this.transferHandler = new AesTransferHandler();
            }
            this.editor.setTransferHandler(this.transferHandler);
            MouseListener mouseListener = new MouseListener(){

                public void mousePressed(MouseEvent mouseEvent) {
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    TransferHandler transferHandler = jComponent.getTransferHandler();
                    transferHandler.exportAsDrag(jComponent, mouseEvent, 2);
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            };
            DragGestureListener dragGestureListener = new DragGestureListener(){

                public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                    try {
                        dragGestureEvent.startDrag(null, AesWidget.this.transferHandler.createTransferable((AesComboBoxEditor)AesWidget.this.variable.getEditor()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this.editor, 3, dragGestureListener);
            this.editor.addMouseListener(mouseListener);
            this.slider = new JSlider(0, 10000);
            this.add((Component)this.slider, new AnchorConstraint(28, 933, 472, 70, 2, 1, 0, 1));
            this.slider.setPreferredSize(new Dimension(214, 41));
            this.slider.setMajorTickSpacing(5000);
            this.slider.setMinorTickSpacing(1000);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            this.options = new JComboBox();
            this.add((Component)this.options, new AnchorConstraint(32, 933, 472, 70, 2, 1, 0, 1));
            this.options.setPreferredSize(new Dimension(214, 33));
            this.options.setRenderer(new IconComboBoxRenderer());
            this.options.setMaximumRowCount(7);
            this.addRemoveButton = new IconButton("/icons/1rightarrow_16.png", "add", null, "add");
            this.add((Component)this.addRemoveButton, new AnchorConstraint(32, 128, 483, 24, 2, 0, 0, 2));
            this.addRemoveButton.setPreferredSize(new Dimension(22, 22));
            this.addRemoveButton.addActionListener(this);
            if (this.variableSelector != null) {
                this.variableSelector.getJComboBox().addActionListener(this);
            }
            this.setMinimumSize(new Dimension(40, 20));
            this.setMaximumSize(new Dimension(500, 100));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initLineOptions() {
        lineOptions = new Vector();
        ImageIcon imageIcon = new ImageIcon();
        imageIcon.setDescription(" ");
        lineOptions.add(imageIcon);
        URL uRL = this.getClass().getResource("/icons/ggplot_icons/points_and_lines/solid_line.png");
        imageIcon = new ImageIcon(uRL);
        imageIcon.setDescription("Solid");
        lineOptions.add(imageIcon);
        uRL = this.getClass().getResource("/icons/ggplot_icons/points_and_lines/dashed_line.png");
        imageIcon = new ImageIcon(uRL);
        imageIcon.setDescription("Dash");
        lineOptions.add(imageIcon);
        uRL = this.getClass().getResource("/icons/ggplot_icons/points_and_lines/dotted_line.png");
        imageIcon = new ImageIcon(uRL);
        imageIcon.setDescription("Dot");
        lineOptions.add(imageIcon);
        uRL = this.getClass().getResource("/icons/ggplot_icons/points_and_lines/dot_dashed_line.png");
        imageIcon = new ImageIcon(uRL);
        imageIcon.setDescription("Dot dash");
        lineOptions.add(imageIcon);
        uRL = this.getClass().getResource("/icons/ggplot_icons/points_and_lines/long_dashed_line.png");
        imageIcon = new ImageIcon(uRL);
        imageIcon.setDescription("Long dash");
        lineOptions.add(imageIcon);
        uRL = this.getClass().getResource("/icons/ggplot_icons/points_and_lines/two_dashed_line.png");
        imageIcon = new ImageIcon(uRL);
        imageIcon.setDescription("Double dash");
        lineOptions.add(imageIcon);
    }

    private void initShapeOptions() {
        shapeOptions = new Vector();
        ImageIcon imageIcon = new ImageIcon();
        imageIcon.setDescription(" ");
        shapeOptions.add(imageIcon);
        for (int i = 1; i <= 25; ++i) {
            URL uRL = this.getClass().getResource("/icons/ggplot_icons/points_and_lines/" + i + ".png");
            imageIcon = new ImageIcon(uRL);
            imageIcon.setDescription("  : " + i);
            shapeOptions.add(imageIcon);
        }
    }

    public void setVariableSelector(VariableSelector variableSelector) {
        if (this.variableSelector != null) {
            this.variableSelector.getJComboBox().removeActionListener(this);
        }
        this.variableSelector = variableSelector;
        this.variableSelector.getJComboBox().addActionListener(this);
    }

    public VariableSelector getVariableSelector() {
        return this.variableSelector;
    }

    public void setModel(Object object) {
        this.setModel((Aes)object);
    }

    public void setModel(Aes aes) {
        boolean bl;
        Color color = new Color(90, 90, 90);
        this.editor.setBackground(Color.white);
        boolean bl2 = bl = aes.defaultVariable != null || aes.variable != null || aes.value != null;
        if (aes.required && !bl) {
            color = new Color(150, 0, 0);
            this.editor.setBackground(this.neededItemBackground);
        }
        if (aes.required && bl) {
            color = new Color(0, 150, 0);
        }
        int n = SwingUtilities.computeStringWidth(this.nameLab.getFontMetrics(this.nameLab.getFont()), aes.title);
        this.nameLab.setText(aes.title);
        this.nameLab.setPreferredSize(new Dimension(n, 22));
        this.nameLab.setForeground(color);
        int n2 = Math.max(10 + n, 56);
        this.remove(this.value);
        this.add((Component)this.value, new AnchorConstraint(13, 50, 764, n2, 2, 2, 0, 2));
        this.value.setVisible(false);
        this.remove(this.colour);
        this.add((Component)this.colour, new AnchorConstraint(13, 50, 764, n2, 2, 2, 0, 2));
        this.colour.setVisible(false);
        this.remove(this.slider);
        this.add((Component)this.slider, new AnchorConstraint(13, 50, 764, n2, 2, 2, 0, 2));
        this.slider.setVisible(false);
        this.remove(this.options);
        this.add((Component)this.options, new AnchorConstraint(13, 50, 764, n2, 2, 2, 0, 2));
        this.options.setVisible(false);
        this.value.removeFocusListener(this.valueValidator);
        this.value.addFocusListener(this.valueValidator);
        this.variable.setSelectedItem(null);
        if (aes.variable != null) {
            this.variable.setSelectedItem(aes.variable);
        }
        if (aes.dataType.equals("any") || aes.dataType.equals("numeric") || aes.dataType.equals("bounded") && (aes.lowerBound == null || aes.upperBound == null)) {
            this.valueComponent = this.value;
            if (aes.value != null) {
                this.value.setText(aes.value.toString());
            }
        } else if (aes.dataType.equals("col")) {
            this.valueComponent = this.colour;
            if (aes.value != null && aes.value instanceof Color) {
                this.colour.setForeground((Color)aes.value);
                this.colourValue = (Color)aes.value;
            } else if (aes.value != null) {
                JOptionPane.showMessageDialog(this, "invalid colour value:" + aes.value.toString());
            }
        } else if (aes.dataType.equals("bounded")) {
            int n3;
            Double d = new Double(0.0);
            if (aes.value != null) {
                double d2 = (Double)aes.value - aes.lowerBound;
                d2 /= aes.upperBound - aes.lowerBound;
                this.sliderValue = d = new Double(d2 *= 10000.0);
                n3 = Math.round(d.floatValue());
            } else {
                n3 = 1;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 10000) {
                n3 = 10000;
            }
            this.slider.setValue(n3);
            this.valueComponent = this.slider;
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(new Integer(0), new JLabel(aes.lowerBound.toString()));
            hashtable.put(new Integer(5000), new JLabel((aes.upperBound - aes.lowerBound) / 2.0 + ""));
            hashtable.put(new Integer(10000), new JLabel(aes.upperBound.toString()));
            this.slider.setLabelTable(hashtable);
            this.slider.setPaintLabels(true);
            this.setMinimumSize(new Dimension(0, 70));
        } else if (aes.dataType.equals("none")) {
            this.valueComponent = new JPanel();
        } else if (aes.dataType.equals("ln")) {
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            for (int i = 0; i < lineOptions.size(); ++i) {
                defaultComboBoxModel.addElement(lineOptions.get(i));
            }
            this.options.setModel(defaultComboBoxModel);
            if (aes.value != null && aes.value instanceof Integer) {
                this.options.setSelectedIndex((Integer)aes.value);
            }
            this.valueComponent = this.options;
        } else if (aes.dataType.equals("shape")) {
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            for (int i = 0; i < shapeOptions.size(); ++i) {
                defaultComboBoxModel.addElement(shapeOptions.get(i));
            }
            this.options.setModel(defaultComboBoxModel);
            if (aes.value != null && aes.value instanceof Integer) {
                this.options.setSelectedIndex((Integer)aes.value);
            }
            this.valueComponent = this.options;
        }
        this.toggleVariable(aes.useVariable);
        this.model = aes;
        this.refreshAddRemoveButton();
    }

    public void updateModel() {
        this.model.useVariable = this.toggleVariable.isSelected();
        Object object = this.variable.getSelectedItem();
        this.model.variable = object != null && object.toString().length() > 0 ? object.toString() : null;
        String string = null;
        if (this.valueComponent == this.value) {
            string = this.value.getText();
            if (string.toString().length() <= 0) {
                this.model.value = null;
            } else if (this.model.dataType.equals("numeric") || this.model.dataType.equals("bounded")) {
                try {
                    Double d = new Double(Double.parseDouble(string));
                    if (this.model.lowerBound != null && d < this.model.lowerBound) {
                        d = (Double)this.model.value;
                        this.value.setText(this.model.value.toString());
                    }
                    if (this.model.upperBound != null && d > this.model.upperBound) {
                        d = (Double)this.model.value;
                        this.value.setText(this.model.value.toString());
                    }
                    this.model.value = d;
                }
                catch (Exception exception) {
                    if (this.model.value != null) {
                        this.value.setText(this.model.value.toString());
                    }
                }
            } else {
                this.model.value = string.toString();
            }
        } else if (this.valueComponent == this.colour) {
            this.model.value = this.colourValue;
        } else if (this.valueComponent == this.slider) {
            double d = this.slider.getValue();
            d /= 10000.0;
            d *= this.model.upperBound - this.model.lowerBound;
            this.model.value = this.sliderValue == null && this.slider.getValue() == 1 ? null : new Double(d += this.model.lowerBound.doubleValue());
        } else if (this.valueComponent == this.options) {
            int n = this.options.getSelectedIndex();
            this.model.value = n <= 0 ? null : new Integer(n);
        }
    }

    public Aes getModel() {
        this.updateModel();
        return this.model;
    }

    public void setCalculatedVariables(Vector vector) {
        Object object = this.variable.getSelectedItem();
        this.statVarModel.removeAllElements();
        this.statVarModel.addElement(null);
        for (int i = 0; i < vector.size(); ++i) {
            this.statVarModel.addElement(".." + vector.get(i).toString() + "..");
        }
        if (this.statVarModel.getSize() < 2) {
            this.variable.setUI(new BasicComboBoxUI(){

                protected JButton createArrowButton() {
                    return new JButton(){

                        public int getWidth() {
                            return 0;
                        }
                    };
                }
            });
            this.variable.validate();
            this.variable.repaint();
        } else {
            this.variable.setUI(this.defaultComboBoxUI);
            this.variable.validate();
            this.variable.repaint();
        }
        this.variable.setSelectedItem(object);
    }

    public void toggleVariable(boolean bl) {
        if (!bl) {
            this.remove(this.nameLab);
            this.add((Component)this.nameLab, new AnchorConstraint(13, 860, 472, 5, 2, 0, 0, 2));
            this.variable.setVisible(false);
            this.addRemoveButton.setVisible(false);
            this.scale.setVisible(false);
            this.toggleVariable.setSelected(false);
            this.toggleValue.setSelected(true);
            this.valueComponent.setVisible(true);
            if (this.valueComponent != this.slider) {
                this.setPreferredSize(new Dimension(200, 35));
            } else {
                this.setPreferredSize(new Dimension(200, 50));
            }
        } else {
            this.remove(this.nameLab);
            this.add((Component)this.nameLab, new AnchorConstraint(13, 860, 472, 56, 2, 0, 0, 2));
            this.variable.setVisible(true);
            this.addRemoveButton.setVisible(true);
            this.scale.setVisible(false);
            this.toggleVariable.setSelected(true);
            this.toggleValue.setSelected(false);
            this.valueComponent.setVisible(false);
            this.setPreferredSize(new Dimension(200, 60));
        }
    }

    public void refreshTitleColour() {
        boolean bl;
        Color color = new Color(90, 90, 90);
        boolean bl2 = bl = this.model.defaultVariable != null || this.model.variable != null || this.model.value != null;
        if (this.model.required && !bl) {
            color = new Color(150, 0, 0);
            this.editor.setBackground(this.neededItemBackground);
        } else {
            this.editor.setBackground(Color.white);
        }
        if (this.model.required && bl) {
            color = new Color(0, 150, 0);
        }
        this.nameLab.setForeground(color);
    }

    public void refreshAddRemoveButton() {
        if (this.addRemoveButton == null || this.variable == null) {
            return;
        }
        if (this.variable.getSelectedItem() == null || this.variable.getSelectedItem().toString().length() <= 0) {
            this.addRemoveButton.setToolTipText("add");
            this.addRemoveButton.setActionCommand("add");
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/icons/1rightarrow_16.png"));
            this.addRemoveButton.setIcon(imageIcon);
        } else {
            this.addRemoveButton.setToolTipText("remove");
            this.addRemoveButton.setActionCommand("remove");
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/icons/1leftarrow_16.png"));
            this.addRemoveButton.setIcon(imageIcon);
        }
    }

    public void setVariable(String string) {
        REXP rEXP;
        String string2 = this.variableSelector.getSelectedData();
        if (this.model.preferNumeric) {
            REXP rEXP2 = Deducer.timedEval("plyr::is.discrete(" + string2 + "$" + string + ")");
            if (rEXP2 != null && rEXP2.isLogical() && ((REXPLogical)rEXP2).isTRUE()[0]) {
                string = "as.numeric(" + string + ")";
            }
        } else if (this.model.preferCategorical && (rEXP = Deducer.timedEval("plyr::is.discrete(" + string2 + "$" + string + ")")) != null && rEXP.isLogical() && ((REXPLogical)rEXP).isFALSE()[0]) {
            string = "as.factor(" + string + ")";
        }
        this.variable.setSelectedItem(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        boolean bl = false;
        if (actionEvent.getSource() == this.toggleValue) {
            bl = !this.toggleValue.isSelected();
            this.toggleVariable(bl);
            return;
        }
        if (actionEvent.getSource() == this.toggleVariable) {
            bl = this.toggleVariable.isSelected();
            this.toggleVariable(bl);
            return;
        }
        if (actionEvent.getSource() == this.colour && (object2 = JColorChooser.showDialog(this, "Choose Colour", this.colourValue != null ? this.colourValue : Color.white)) != null) {
            this.colour.setForeground((Color)object2);
            this.colourValue = object2;
        }
        if (actionEvent.getSource() == this.scale) {
            JOptionPane.showMessageDialog(this, "TODO: unimplemented");
        }
        if (actionEvent.getSource() == this.addRemoveButton) {
            object2 = actionEvent.getActionCommand();
            if (this.variableSelector != null) {
                if (object2 == "add") {
                    object = this.variableSelector.getSelectedVariables();
                    if (((ArrayList)object).size() > 0) {
                        this.setVariable((String)((ArrayList)object).get(0));
                    }
                } else if (object2 == "remove") {
                    this.variable.setSelectedItem(null);
                }
            }
        }
        if (actionEvent.getSource() == this.variableSelector.getJComboBox()) {
            object2 = this.variable.getSelectedItem();
            object = this.variableSelector.getSelectedData();
            if (object2 != null && !object2.toString().startsWith("..")) {
                boolean bl2 = ((REXPLogical)Deducer.timedEval("'" + object2.toString() + "' %in% names(" + (String)object + ")")).isTRUE()[0];
                if (!bl2) {
                    this.variable.setSelectedItem(null);
                }
                this.refreshAddRemoveButton();
            }
        }
        if (actionEvent.getSource() == this.variable) {
            this.refreshAddRemoveButton();
        }
        if (this.model != null) {
            this.updateModel();
            this.refreshTitleColour();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        String string;
        if (mouseEvent.getClickCount() == 2 && (string = JOptionPane.showInputDialog(this.variable, "Edit variable by hand. For example log(variable)", (object = this.variable.getSelectedItem()) == null ? null : object.toString())) != null) {
            this.variable.setSelectedItem(string);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        String string;
        if (mouseEvent.isPopupTrigger() && (string = JOptionPane.showInputDialog(this.variable, "Edit variable by hand. For example log(variable)", (object = this.variable.getSelectedItem()) == null ? null : object.toString())) != null) {
            this.variable.setSelectedItem(string);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        String string;
        if (mouseEvent.isPopupTrigger() && (string = JOptionPane.showInputDialog(this.variable, "Edit variable by hand. For example log(variable)", (object = this.variable.getSelectedItem()) == null ? null : object.toString())) != null) {
            this.variable.setSelectedItem(string);
        }
    }

    public void setShowToggle(boolean bl) {
        this.showToggle = bl;
        this.toggleVariable.setVisible(bl);
        this.toggleValue.setVisible(bl);
    }

    public boolean isShowToggle() {
        return this.showToggle;
    }

    public class ArrayListTransferable
    implements Transferable {
        DataFlavor arrayListFlavor = new DataFlavor(class$java$util$ArrayList == null ? (class$java$util$ArrayList = AesWidget.class$("java.util.ArrayList")) : class$java$util$ArrayList, "ArrayList");
        ArrayList data;

        public ArrayListTransferable(ArrayList arrayList) {
            this.data = arrayList;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.data;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.arrayListFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.arrayListFlavor.equals(dataFlavor);
        }
    }

    class AesTransferHandler
    extends TransferHandler {
        DataFlavor arrayListFlavor = new DataFlavor(class$java$util$ArrayList == null ? (class$java$util$ArrayList = AesWidget.class$("java.util.ArrayList")) : class$java$util$ArrayList, "ArrayList");
        ArrayList lastData = new ArrayList();

        AesTransferHandler() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                if (transferable.isDataFlavorSupported(this.arrayListFlavor)) {
                    ArrayList arrayList = (ArrayList)transferable.getTransferData(this.arrayListFlavor);
                    if (arrayList.size() > 1) {
                        return false;
                    }
                    String string = arrayList.get(0).toString();
                    AesWidget.this.setVariable(string);
                    return true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }

        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            AesComboBoxEditor aesComboBoxEditor = (AesComboBoxEditor)jComponent;
            aesComboBoxEditor.setItem("");
        }

        public Transferable createTransferable(JComponent jComponent) {
            ArrayList<String> arrayList = new ArrayList<String>();
            AesComboBoxEditor aesComboBoxEditor = (AesComboBoxEditor)jComponent;
            arrayList.add(aesComboBoxEditor.getText());
            aesComboBoxEditor.setItem("");
            return new ArrayListTransferable(arrayList);
        }
    }

    class ValueValidator
    implements FocusListener {
        ValueValidator() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (AesWidget.this.model != null) {
                AesWidget.this.updateModel();
                AesWidget.this.refreshTitleColour();
            }
        }
    }

    class IconComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public IconComboBoxRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (!(object instanceof ImageIcon)) {
                this.setIcon(null);
                this.setText(object.toString());
                return this;
            }
            ImageIcon imageIcon = (ImageIcon)object;
            if (imageIcon.getImage() != null) {
                this.setIcon(imageIcon);
            } else {
                this.setIcon(null);
            }
            this.setText(imageIcon.getDescription());
            return this;
        }
    }

    class AesComboBoxEditor
    extends JLabel
    implements ComboBoxEditor {
        public AesComboBoxEditor() {
            this.setOpaque(true);
            this.setBackground(Color.white);
        }

        public Component getEditorComponent() {
            return this;
        }

        public Object getItem() {
            return this.getText();
        }

        public void setItem(Object object) {
            if (object != null) {
                this.setText(object.toString());
                AesWidget.this.variable.setSelectedItem(object.toString());
            } else {
                this.setText("");
                AesWidget.this.variable.setSelectedItem("");
            }
            AesWidget.this.refreshAddRemoveButton();
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public void removeActionListener(ActionListener actionListener) {
        }

        public void selectAll() {
        }
    }
}

