/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.DeducerWidget;

public class VectorBuilderWidget
extends JPanel
implements ActionListener,
DeducerWidget {
    protected JList list;
    protected DefaultListModel listModel;
    protected DefaultListModel lastModel;
    protected DefaultListModel initialModel;
    protected JScrollPane scroller;
    private JButton add;
    protected String title;
    private JButton remove;
    protected boolean isNumeric = true;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new VectorBuilderWidget());
        jFrame.setDefaultCloseOperation(2);
        jFrame.setSize(100, 100);
        jFrame.setVisible(true);
    }

    public VectorBuilderWidget() {
        this.initGUI();
    }

    public VectorBuilderWidget(String string) {
        this.title = string;
        this.initGUI();
    }

    public VectorBuilderWidget(String string, String[] stringArray) {
        this.title = string;
        this.initGUI();
        this.setDefaultModel(stringArray);
    }

    public VectorBuilderWidget(String[] stringArray) {
        this.initGUI();
        this.setDefaultModel(stringArray);
    }

    public void initGUI() {
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.setPreferredSize(new Dimension(89, 195));
        this.add = new JButton();
        this.add((Component)this.add, new AnchorConstraint(173, 1000, 1000, 511, 0, 1, 1, 1));
        this.add.setText("+");
        this.add.setPreferredSize(new Dimension(44, 22));
        this.add.addActionListener(this);
        this.remove = new JButton();
        this.add((Component)this.remove, new AnchorConstraint(173, 511, 1000, 0, 0, 1, 1, 1));
        this.remove.setText("-");
        this.remove.setPreferredSize(new Dimension(44, 22));
        this.remove.addActionListener(this);
        this.scroller = new JScrollPane();
        this.add((Component)this.scroller, new AnchorConstraint(2, 1005, 22, 5, 1, 1, 2, 1));
        this.scroller.setPreferredSize(new Dimension(89, 173));
        this.list = new JList();
        this.scroller.setViewportView(this.list);
        this.listModel = new DefaultListModel();
        this.list.setModel(this.listModel);
        this.initialModel = new DefaultListModel();
        if (this.title != null) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void setNumeric(boolean bl) {
        this.isNumeric = bl;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public void addItems(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.listModel.addElement(objectArray[i]);
        }
    }

    public void addItem(Object object) {
        this.listModel.addElement(object);
    }

    public void addItem(Object object, int n) {
        this.listModel.add(n, object);
    }

    public void addItem(String string, int n) {
        this.listModel.add(n, string);
    }

    public void addItems(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.listModel.addElement(stringArray[i]);
        }
    }

    public void addItem(String string) {
        this.listModel.addElement(string);
    }

    public void setDefaultModel(Object[] objectArray) {
        this.initialModel = new DefaultListModel();
        for (int i = 0; i < objectArray.length; ++i) {
            this.initialModel.addElement(objectArray[i]);
        }
    }

    public void setDefaultModel(String[] stringArray) {
        this.initialModel = new DefaultListModel();
        for (int i = 0; i < stringArray.length; ++i) {
            this.initialModel.addElement(stringArray[i]);
        }
    }

    public boolean removeItems(Object[] objectArray) {
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl2 = this.listModel.removeElement(objectArray[i]);
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    public boolean removeItems(String[] stringArray) {
        return this.removeItems(stringArray);
    }

    public boolean removeItem(Object object) {
        return this.listModel.removeElement(object);
    }

    public boolean removeItem(String string) {
        return this.listModel.removeElement(string);
    }

    public Object removeItem(int n) {
        return this.listModel.remove(n);
    }

    public void removeAllItems() {
        this.listModel.removeAllElements();
    }

    public JList getList() {
        return this.list;
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    public Object[] getSelectedItems() {
        return this.list.getSelectedValues();
    }

    public void addListener(EventListener eventListener) {
        if (eventListener instanceof ListSelectionListener) {
            this.list.addListSelectionListener((ListSelectionListener)eventListener);
        }
        if (eventListener instanceof MouseListener) {
            this.list.addMouseListener((MouseListener)eventListener);
        }
        if (eventListener instanceof KeyListener) {
            this.list.addKeyListener((KeyListener)eventListener);
        }
    }

    public Object getModel() {
        return this.listModel;
    }

    public String getRModel() {
        return Deducer.makeRCollection(this.listModel, "c", true);
    }

    public String getTitle() {
        return this.title;
    }

    public void reset() {
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < this.initialModel.size(); ++i) {
            defaultListModel.addElement(this.initialModel.get(i));
        }
        this.listModel = defaultListModel;
        this.list.setModel(this.listModel);
    }

    public void resetToLast() {
        if (this.lastModel == null) {
            this.reset();
            return;
        }
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < this.lastModel.size(); ++i) {
            defaultListModel.addElement(this.lastModel.get(i));
        }
        this.listModel = defaultListModel;
        this.list.setModel(this.listModel);
    }

    public void setDefaultModel(Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)object;
        DefaultListModel defaultListModel2 = new DefaultListModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            defaultListModel2.addElement(defaultListModel.get(i));
        }
        this.initialModel = defaultListModel;
    }

    public void setLastModel(Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)object;
        DefaultListModel defaultListModel2 = new DefaultListModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            defaultListModel2.addElement(defaultListModel.get(i));
        }
        this.lastModel = defaultListModel;
    }

    public void setModel(Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)object;
        DefaultListModel defaultListModel2 = new DefaultListModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            defaultListModel2.addElement(defaultListModel.get(i));
        }
        this.listModel = defaultListModel;
        this.list.setModel(this.listModel);
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        if (string == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else if (bl) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = actionEvent.getActionCommand();
        if (string2 == "-") {
            Object[] objectArray = this.list.getSelectedValues();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.listModel.removeElement(objectArray[i]);
                }
            }
        } else if (string2 == "+" && (string = JOptionPane.showInputDialog(this.add, (Object)"Enter a value")) != null) {
            if (this.isNumeric) {
                try {
                    Double.parseDouble(string);
                    this.listModel.addElement(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.add, "Invalid entry. must be a number.");
                }
            } else {
                if (!string.startsWith("\"")) {
                    string = "\"" + string;
                }
                if (!string.endsWith("\"")) {
                    string = string + "\"";
                }
                this.listModel.addElement(string);
            }
        }
    }
}

