/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultListModel;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.deducer.models.ModelModel;
import org.rosuda.deducer.models.RModel;

public class GLMModel
extends ModelModel {
    public DefaultListModel weights = new DefaultListModel();
    public String family = "gaussian()";
    public GLMOptions options = new GLMOptions();
    public PostHoc posthoc = new PostHoc();
    public Export export = new Export();
    public Effects effects = new Effects();
    public Plots plots = new Plots();
    public Tests tests = new Tests();

    public RModel run(boolean bl, RModel rModel) {
        RModel rModel2 = new RModel();
        String string = "";
        boolean bl2 = ((REXPLogical)Deducer.timedEval("'" + Deducer.guiEnv + "' %in% .getOtherObjects()")).isTRUE()[0];
        if (!bl2) {
            Deducer.timedEval(Deducer.guiEnv + "<-new.env(parent=emptyenv())");
        }
        String string2 = bl ? (rModel == null ? Deducer.guiEnv + "$" + Deducer.getUniqueName("model.glm", Deducer.guiEnv) : rModel.modelName) : (this.export.modelName.equals("<auto>") || this.export.modelName.equals("") ? Deducer.getUniqueName("model.glm") : RController.makeValidVariableName((String)this.export.modelName));
        String string3 = bl ? (rModel == null ? Deducer.guiEnv + "$" + Deducer.getUniqueName(this.data, Deducer.guiEnv) : rModel.data) : this.data;
        String string4 = Deducer.makeFormula(this.outcomes, this.terms);
        string = string + string2 + " <- glm(formula=" + string4 + ",family=" + this.family + ",data=" + string3 + (this.weights.getSize() == 0 ? "" : ",weights=" + this.weights.get(0)) + (this.subset == null || this.subset.length() == 0 ? "" : ",subset = " + this.subset) + ",na.action=na.omit" + ")";
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{};
        if (bl) {
            Deducer.timedEval(string3 + "<-" + this.data);
            Deducer.timedEval(string);
            arrayList.add("\n>" + string);
        }
        string = this.runOptions(string, string2, bl, arrayList);
        string = this.runPostHoc(string, string2, bl, arrayList);
        string = this.runEffects(string, string2, bl, arrayList, rModel);
        string = this.runPlots(string, string2, bl, arrayList, rModel);
        string = this.runTests(string, string2, bl, arrayList, rModel);
        string = this.runExport(string, string2, bl, arrayList, string3, false);
        if (!bl) {
            Deducer.execute(string);
        }
        String string5 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string5 = string5 + arrayList.get(i) + "\n";
        }
        rModel2.call = string;
        rModel2.data = string3;
        rModel2.formula = string4;
        rModel2.modelName = string2;
        rModel2.preview = string5;
        return rModel2;
    }

    protected String runOptions(String string, String string2, boolean bl, ArrayList arrayList) {
        block24: {
            try {
                int n;
                String string3;
                String[] stringArray = new String[]{};
                if (this.options.anova) {
                    string3 = "Anova(" + string2 + ",type='" + this.options.type + "',test.statistic='" + this.options.test + "')";
                    if (bl) {
                        try {
                            stringArray = Deducer.timedEval("capture.output(" + string3 + ")").asStrings();
                        }
                        catch (Exception exception) {
                            stringArray = new String[]{};
                        }
                        arrayList.add("\n>" + string3 + "\n");
                        for (n = 0; n < stringArray.length; ++n) {
                            arrayList.add(stringArray[n]);
                        }
                    } else {
                        string = string + "\n" + string3;
                    }
                }
                if (this.options.summary) {
                    string3 = "summary(" + string2 + (this.options.paramCor ? ",correlation=TRUE" : "") + ")";
                    if (bl) {
                        try {
                            stringArray = Deducer.timedEval("capture.output(" + string3 + ")").asStrings();
                        }
                        catch (Exception exception) {
                            stringArray = new String[]{};
                        }
                        arrayList.add("\n>" + string3 + "\n");
                        for (n = 0; n < stringArray.length; ++n) {
                            arrayList.add(stringArray[n]);
                        }
                    } else {
                        string = string + "\n" + string3;
                    }
                }
                if (this.options.vif) {
                    string3 = "vif(" + string2 + ")";
                    if (bl) {
                        try {
                            stringArray = Deducer.timedEval("capture.output(" + string3 + ")").asStrings();
                        }
                        catch (Exception exception) {
                            stringArray = new String[]{};
                        }
                        arrayList.add("\n>" + string3 + "\n");
                        for (n = 0; n < stringArray.length; ++n) {
                            arrayList.add(stringArray[n]);
                        }
                    } else {
                        string = string + "\n" + string3;
                    }
                }
                if (!this.options.influence) break block24;
                string3 = "summary(influence.measures(" + string2 + "))";
                if (bl) {
                    try {
                        stringArray = Deducer.timedEval("capture.output(" + string3 + ")").asStrings();
                    }
                    catch (Exception exception) {
                        stringArray = new String[]{};
                    }
                    arrayList.add("\n>" + string3 + "\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        arrayList.add(stringArray[i]);
                    }
                    break block24;
                }
                string = string + "\n" + string3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                new ErrorMsg(exception);
            }
        }
        return string;
    }

    protected String runPostHoc(String string, String string2, boolean bl, ArrayList arrayList) {
        String[] stringArray = new String[]{};
        if (this.posthoc.posthoc.size() > 0) {
            string = string + "\nlibrary(multcomp)";
            String string3 = "";
            String string4 = "univariate()";
            if (this.posthoc.correction != "No Correction") {
                string4 = "adjusted(\"" + this.posthoc.correction + "\")";
            }
            for (int i = 0; i < this.posthoc.posthoc.getSize(); ++i) {
                int n;
                string3 = "summary(glht(" + string2 + ",linfct=mcp('" + this.posthoc.posthoc.get(i) + "'=\"" + this.posthoc.type + "\")),test=" + string4 + ")";
                if (bl) {
                    try {
                        stringArray = Deducer.timedEval("capture.output(" + string3 + ")").asStrings();
                    }
                    catch (Exception exception) {
                        stringArray = new String[]{""};
                        this.posthoc = new PostHoc();
                        return string;
                    }
                    arrayList.add("\n>" + string3 + "\n");
                    for (n = 0; n < stringArray.length; ++n) {
                        arrayList.add(stringArray[n]);
                    }
                } else {
                    string = string + "\n" + string3;
                }
                if (!this.posthoc.confInt) continue;
                string3 = "confint(glht(" + string2 + ",linfct=mcp('" + this.posthoc.posthoc.get(i) + "'=\"" + this.posthoc.type + "\")))";
                if (bl) {
                    try {
                        Deducer.timedEval("library(multcomp)");
                        stringArray = Deducer.timedEval("capture.output(" + string3 + ")").asStrings();
                    }
                    catch (Exception exception) {
                        stringArray = new String[]{""};
                    }
                    arrayList.add("\n>" + string3 + "\n");
                    for (n = 0; n < stringArray.length; ++n) {
                        arrayList.add(stringArray[n]);
                    }
                    continue;
                }
                string = string + "\n" + string3;
            }
        }
        return string;
    }

    protected String runEffects(String string, String string2, boolean bl, ArrayList arrayList, RModel rModel) {
        block11: {
            try {
                String[] stringArray = new String[]{};
                if (this.effects.effects.size() <= 0) break block11;
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < this.effects.effects.size(); ++i) {
                    vector.add("\"" + this.effects.effects.get(i) + "\"");
                }
                Vector<String> vector2 = new Vector<String>();
                vector2.add("library(effects)");
                for (int i = 0; i < vector.size(); ++i) {
                    if (this.effects.confInt) {
                        vector2.add("summary(effect(term=" + vector.get(i) + ",mod=" + string2 + "))");
                        continue;
                    }
                    vector2.add("\neffect(term=" + vector.get(i) + ",mod=" + string2 + ")");
                }
                if (bl) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        String string3 = (String)vector2.get(i);
                        try {
                            stringArray = Deducer.timedEval("capture.output(" + string3 + ")").asStrings();
                        }
                        catch (Exception exception) {
                            stringArray = new String[]{};
                        }
                        arrayList.add("\n>" + string3 + "\n");
                        for (int j = 0; j < stringArray.length; ++j) {
                            arrayList.add(stringArray[j]);
                        }
                    }
                    break block11;
                }
                for (int i = 0; i < vector2.size(); ++i) {
                    String string4 = (String)vector2.get(i);
                    string = string + "\n" + string4;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                new ErrorMsg(exception);
            }
        }
        return string;
    }

    protected String runPlots(String string, String string2, boolean bl, ArrayList arrayList, RModel rModel) {
        try {
            String[] stringArray = new String[]{};
            if (this.plots.effects.size() > 0) {
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < this.plots.effects.size(); ++i) {
                    vector.add("\"" + this.plots.effects.get(i) + "\"");
                }
                Vector<String> vector2 = new Vector<String>();
                vector2.add("library(effects)");
                for (int i = 0; i < vector.size(); ++i) {
                    vector2.add("dev.new()");
                    vector2.add("plot(effect(term=" + vector.get(i) + ",mod=" + string2 + ",default.levels=" + this.plots.defaultLevels + (this.plots.confInt ? "" : ",se=FALSE") + ")" + (this.plots.ylab != "" && !this.plots.ylab.equals("<auto>") ? ",ylab='" + this.plots.ylab + "'" : "") + (this.plots.scaled ? "" : ",rescale.axis=FALSE") + (this.plots.multi ? ",multiline=TRUE" : "") + (this.plots.rug ? "" : ",rug=FALSE") + ")");
                }
                if (!bl) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        String string3 = (String)vector2.get(i);
                        string = string + "\n" + string3;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new ErrorMsg(exception);
        }
        return string;
    }

    protected String runTests(String string, String string2, boolean bl, ArrayList arrayList, RModel rModel) {
        block17: {
            try {
                Object object;
                String[] stringArray = new String[]{};
                if (this.tests.size() <= 0) break block17;
                String[] stringArray2 = new String[1];
                try {
                    if (bl && rModel != null) {
                        stringArray2 = Deducer.timedEval("names(coef(" + rModel.modelName + "))").asStrings();
                    } else if (bl) {
                        stringArray2 = Deducer.timedEval("names(coef(" + string2 + "))").asStrings();
                    }
                }
                catch (Exception exception) {
                    stringArray2 = new String[]{};
                }
                Vector<String> vector = new Vector<String>();
                String string3 = bl ? Deducer.guiEnv + "$" + Deducer.getUniqueName("lh.mat", Deducer.guiEnv) : Deducer.getUniqueName("lh.mat");
                String string4 = "";
                for (int i = 0; i < this.tests.size(); ++i) {
                    ExDefaultTableModel exDefaultTableModel = this.tests.getModel(i);
                    if (bl && (rModel != null && exDefaultTableModel.getColumnCount() != stringArray2.length + 1 || rModel == null && bl && exDefaultTableModel.getColumnCount() != stringArray2.length + 1)) continue;
                    object = new Vector();
                    Vector<Object> vector2 = new Vector<Object>();
                    string4 = string3 + "<-rbind(";
                    for (int j = 0; j < exDefaultTableModel.getRowCount(); ++j) {
                        ((Vector)object).clear();
                        for (int k = 0; k < exDefaultTableModel.getColumnCount() - 1; ++k) {
                            ((Vector)object).add(exDefaultTableModel.getValueAt(j, k));
                        }
                        string4 = string4 + RController.makeRVector((Vector)object);
                        string4 = j < exDefaultTableModel.getRowCount() - 1 ? string4 + ",\n\t" : string4 + ")";
                        vector2.add(exDefaultTableModel.getValueAt(j, exDefaultTableModel.getColumnCount() - 1));
                    }
                    vector.add(string4);
                    string4 = "lht(" + string2 + "," + string3 + "," + RController.makeRVector(vector2) + ")";
                    vector.add(string4);
                }
                if (bl) {
                    if (vector.size() > 0) {
                        vector.add("rm('" + string3.split("\\$")[1] + "',envir=" + Deducer.guiEnv + ")");
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        String string5 = (String)vector.get(i);
                        object = Deducer.timedEval("capture.output(" + string5.replaceAll("\n", "").replaceAll("\t", "") + ")");
                        stringArray = object != null ? ((REXP)object).asStrings() : new String[]{"Error"};
                        arrayList.add("\n>" + string5 + "\n");
                        for (int j = 0; j < stringArray.length; ++j) {
                            arrayList.add(stringArray[j]);
                        }
                    }
                } else {
                    if (vector.size() > 0) {
                        vector.add("rm('" + string3 + "')");
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        String string6 = (String)vector.get(i);
                        string = string + "\n" + string6;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                new ErrorMsg(exception);
            }
        }
        return string;
    }

    protected String runExport(String string, String string2, boolean bl, ArrayList arrayList, String string3, boolean bl2) {
        try {
            if (!bl) {
                String string4;
                String string5;
                String string6;
                String string7 = Deducer.getUniqueName("tmp");
                boolean bl3 = false;
                if (this.export.cooks) {
                    bl3 = true;
                    string = string + "\n" + string7 + "<-cooks.distance(" + string2 + ")";
                    string = string + "\n" + string3 + "[names(" + string7 + "),\"" + Deducer.timedEval("rev(make.unique(c(names(" + string3 + "),\"cooks\")))[1]").asString() + "\"]<-" + string7;
                }
                if (this.export.resid) {
                    bl3 = true;
                    string = string + "\n" + string7 + "<-residuals(" + string2 + ")";
                    string = string + "\n" + string3 + "[names(" + string7 + "),\"" + Deducer.timedEval("rev(make.unique(c(names(" + string3 + "),\"Residuals\")))[1]").asString() + "\"]<-" + string7;
                }
                if (this.export.sdresid) {
                    bl3 = true;
                    string = string + "\n" + string7 + "<-rstandard(" + string2 + ")";
                    string = string + "\n" + string3 + "[names(" + string7 + "),\"" + Deducer.timedEval("rev(make.unique(c(names(" + string3 + "),\"resid.standardized\")))[1]").asString() + "\"]<-" + string7;
                }
                if (this.export.stresid) {
                    bl3 = true;
                    string = string + "\n" + string7 + "<-rstudent(" + string2 + ")";
                    string = string + "\n" + string3 + "[names(" + string7 + "),\"" + Deducer.timedEval("rev(make.unique(c(names(" + string3 + "),\"resid.studentized\")))[1]").asString() + "\"]<-" + string7;
                }
                if (this.export.pred && !bl2) {
                    bl3 = true;
                    string6 = this.export.data.equals("") ? string3 : this.export.data;
                    string5 = "newdata=" + string6;
                    string4 = Deducer.timedEval("rev(make.unique(c(names(" + string6 + "),\"predicted.resp\")))[1]").asString();
                    string = string + "\n" + string6 + "[[\"" + string4 + "\"]] <- predict(" + string2 + ", " + string5 + ",type='response')";
                } else if (this.export.pred) {
                    string6 = this.export.data.equals("") ? string3 : this.export.data;
                    string5 = "newdata=" + string6;
                    string4 = Deducer.timedEval("rev(make.unique(c(names(" + string6 + "),\"predicted.link\")))[1]").asString();
                    string = string + "\n" + string6 + "[[\"" + string4 + "\"]] <- predict(" + string2 + ", " + string5 + ")";
                    bl3 = true;
                }
                if (this.export.linearPred && !bl2) {
                    string6 = this.export.data.equals("") ? string3 : this.export.data;
                    string5 = "newdata=" + string6;
                    string4 = Deducer.timedEval("rev(make.unique(c(names(" + string6 + "),\"predicted\")))[1]").asString();
                    string = string + "\n" + string6 + "[[\"" + string4 + "\"]] <- predict(" + string2 + ", " + string5 + ",type='link')";
                    bl3 = true;
                }
                if (this.export.dfbeta) {
                    bl3 = true;
                    string = string + "\n" + Deducer.getUniqueName(string2 + ".dfbeta") + "<-dfbeta(" + string2 + ")";
                }
                if (this.export.dffits) {
                    bl3 = true;
                    string = string + "\n" + string7 + "<-dffits(" + string2 + ")";
                    string = string + "\n" + string3 + "[names(" + string7 + "),\"" + Deducer.timedEval("rev(make.unique(c(names(" + string3 + "),\"dffits\")))[1]").asString() + "\"]<-" + string7;
                }
                if (this.export.hats) {
                    bl3 = true;
                    string = string + "\n" + string7 + "<-hatvalues(" + string2 + ")";
                    string = string + "\n" + string3 + "[names(" + string7 + "),\"" + Deducer.timedEval("rev(make.unique(c(names(" + string3 + "),\"hats\")))[1]").asString() + "\"]<-" + string7;
                }
                if (this.export.covratio) {
                    bl3 = true;
                    string = string + "\n" + string7 + "<-covratio(" + string2 + ")";
                    string = string + "\n" + string3 + "[names(" + string7 + "),\"" + Deducer.timedEval("rev(make.unique(c(names(" + string3 + "),\"cov.ratio\")))[1]").asString() + "\"]<-" + string7;
                }
                if (!this.export.keepModel) {
                    string = string + "\nrm('" + string2 + "')";
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new ErrorMsg(exception);
        }
        return string;
    }

    class Tests {
        public String direction = "two.sided";
        private ArrayList tableModelList = new ArrayList();
        private ArrayList testNames = new ArrayList();

        Tests() {
        }

        public void reset() {
            this.direction = "two.sided";
            this.tableModelList = new ArrayList();
            this.testNames = new ArrayList();
        }

        public int size() {
            return this.tableModelList.size();
        }

        public ExDefaultTableModel getModel(int n) {
            return (ExDefaultTableModel)this.tableModelList.get(n);
        }

        public String getName(int n) {
            return (String)this.testNames.get(n);
        }

        public ExDefaultTableModel getDuplicateTableModel(int n) {
            ExDefaultTableModel exDefaultTableModel = (ExDefaultTableModel)this.tableModelList.get(n);
            ExDefaultTableModel exDefaultTableModel2 = new ExDefaultTableModel();
            exDefaultTableModel2.setColumnCount(exDefaultTableModel.getColumnCount());
            exDefaultTableModel2.setRowCount(exDefaultTableModel.getRowCount());
            for (int i = 0; i < exDefaultTableModel.getRowCount(); ++i) {
                for (int j = 0; j < exDefaultTableModel.getColumnCount(); ++j) {
                    exDefaultTableModel2.setValueAt(exDefaultTableModel.getValueAt(i, j), i, j);
                }
            }
            return exDefaultTableModel2;
        }

        public void addTest(String string, ExDefaultTableModel exDefaultTableModel) {
            this.tableModelList.add(exDefaultTableModel);
            this.testNames.add(string);
        }
    }

    class Plots {
        public DefaultListModel effects = new DefaultListModel();
        public boolean confInt = true;
        public boolean scaled = false;
        public boolean multi = false;
        public boolean rug = true;
        public String ylab = "<auto>";
        public int defaultLevels = 20;

        Plots() {
        }
    }

    class Effects {
        public DefaultListModel effects = new DefaultListModel();
        public boolean confInt = false;

        Effects() {
        }
    }

    class Export {
        public boolean resid = false;
        public boolean sdresid = false;
        public boolean stresid = false;
        public boolean pred = false;
        public boolean linearPred = false;
        public boolean dfbeta = false;
        public boolean dffits = false;
        public boolean covratio = false;
        public boolean hats = false;
        public boolean cooks = false;
        public boolean keepModel = false;
        public String modelName = "<auto>";
        public String data = "";

        Export() {
        }
    }

    class PostHoc {
        public DefaultListModel posthoc = new DefaultListModel();
        public String type = "Tukey";
        public boolean confInt = false;
        public String correction = "No Correction";

        PostHoc() {
        }
    }

    class GLMOptions {
        public boolean summary = true;
        public boolean paramCor = false;
        public boolean anova = true;
        public String type = "II";
        public String test = "Wald";
        public boolean vif = false;
        public boolean influence = false;

        GLMOptions() {
        }
    }
}

