/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.SingletonAddRemoveButton;
import org.rosuda.deducer.toolkit.SingletonDJList;
import org.rosuda.deducer.widgets.DeducerWidget;
import org.rosuda.deducer.widgets.VariableSelectorWidget;

public class SingleVariableWidget
extends JPanel
implements DeducerWidget,
ActionListener {
    private SingletonAddRemoveButton addRemoveButton;
    private SingletonDJList singleList;
    private JPanel listPanel;
    private VariableSelectorWidget selector;
    private String title;
    private DefaultListModel initialModel;
    private DefaultListModel lastModel;

    public SingleVariableWidget(String string, VariableSelectorWidget variableSelectorWidget) {
        this.selector = variableSelectorWidget;
        this.title = string;
        this.selector.getJComboBox().addActionListener(this);
        this.initGUI();
    }

    public SingleVariableWidget(VariableSelectorWidget variableSelectorWidget) {
        this(null, variableSelectorWidget);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(239, 65));
            this.listPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.add((Component)this.listPanel, new AnchorConstraint(5, 1002, 940, 64, 2, 1, 0, 2));
            this.listPanel.setPreferredSize(new Dimension(195, 50));
            this.listPanel.setLayout(borderLayout);
            if (this.title != null) {
                this.listPanel.setBorder(BorderFactory.createTitledBorder(this.title));
            }
            this.singleList = new SingletonDJList();
            this.listPanel.add((Component)this.singleList, "Center");
            this.singleList.setModel(new DefaultListModel());
            this.singleList.setBorder(BorderFactory.createBevelBorder(1));
            this.addRemoveButton = new SingletonAddRemoveButton(new String[]{"Add", "Remove"}, new String[]{"Add", "Remove"}, this.singleList, this.selector);
            this.add((Component)this.addRemoveButton, new AnchorConstraint(16, 156, 845, 0, 2, 0, 0, 2));
            this.addRemoveButton.setPreferredSize(new Dimension(32, 34));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.initialModel == null) {
            this.setModel(new DefaultListModel());
        } else {
            this.setModel(this.initialModel);
        }
    }

    public SingletonDJList getList() {
        return this.singleList;
    }

    public SingletonAddRemoveButton getButton() {
        return this.addRemoveButton;
    }

    public String getSelectedVariable() {
        DefaultListModel defaultListModel = (DefaultListModel)this.singleList.getModel();
        if (defaultListModel.size() == 0) {
            return null;
        }
        return defaultListModel.get(0).toString();
    }

    public void setSelectedVariable(String string) {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        if (string != null) {
            defaultListModel.addElement(string);
        }
        this.setModel(defaultListModel);
    }

    public void setDefaultVariable(String string) {
        this.initialModel = new DefaultListModel();
        if (string != null) {
            this.initialModel.addElement(string);
        }
    }

    public void addListener(EventListener eventListener) {
        if (eventListener instanceof ActionListener) {
            this.addRemoveButton.addActionListener((ActionListener)eventListener);
        }
        if (eventListener instanceof ListSelectionListener) {
            this.singleList.addListSelectionListener((ListSelectionListener)eventListener);
        }
        if (eventListener instanceof MouseListener) {
            this.singleList.addMouseListener((MouseListener)eventListener);
        }
    }

    public void setModel(DefaultListModel defaultListModel, boolean bl) {
        if (bl && this.selector == null) {
            this.setModel(defaultListModel, false);
        } else {
            if (defaultListModel == null) {
                defaultListModel = new DefaultListModel();
            }
            DefaultListModel defaultListModel2 = new DefaultListModel();
            for (int i = 0; i < defaultListModel.size(); ++i) {
                if (bl) {
                    boolean bl2 = this.selector.remove(defaultListModel.get(i));
                    defaultListModel2.addElement(defaultListModel.get(i));
                    continue;
                }
                defaultListModel2.addElement(defaultListModel.get(i));
            }
            this.singleList.getModel().removeListDataListener(this.addRemoveButton);
            this.singleList.setModel(defaultListModel2);
            this.addRemoveButton.refreshListListener();
        }
    }

    public Object getModel() {
        return this.singleList.getModel();
    }

    public String getRModel() {
        String string = Deducer.makeRCollection(this.singleList.getModel(), "c", true);
        return string;
    }

    public String getTitle() {
        return this.title;
    }

    public void reset() {
        String string = this.getSelectedVariable();
        if (string != null) {
            this.selector.add(string);
        }
        this.setModel(this.initialModel);
    }

    public void resetToLast() {
        this.setModel(this.lastModel);
    }

    public void setDefaultModel(Object object) {
        this.initialModel = (DefaultListModel)object;
        if (this.lastModel == null) {
            this.lastModel = (DefaultListModel)object;
        }
    }

    public void setLastModel(Object object) {
        this.lastModel = (DefaultListModel)object;
    }

    public void setModel(Object object) {
        this.setModel((DefaultListModel)object, true);
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        if (string == null) {
            this.listPanel.setBorder(BorderFactory.createEmptyBorder());
        } else if (bl) {
            this.listPanel.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }
}

