/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.deducer.data.RowNamesListModel;

class RDataFrameVariableModel
extends ExDefaultTableModel {
    private static String guiEnv = Deducer.guiEnv;
    private String rDataName = null;
    private String tempDataName = null;
    private VariableNumberListModel rowNamesModel;
    private final int numExtraColumns = 1;
    String[] varNames = new String[0];
    String[] classes = new String[0];
    String[] factorLevels = new String[0];

    public RDataFrameVariableModel() {
    }

    public RDataFrameVariableModel(String string) {
        boolean bl = ((REXPLogical)Deducer.eval("'" + guiEnv + "' %in% .getOtherObjects()")).isTRUE()[0];
        if (!bl) {
            Deducer.eval(guiEnv + "<-new.env(parent=emptyenv())");
        }
        if (this.tempDataName != null) {
            this.removeCachedData();
        }
        this.rDataName = string;
        if (this.rDataName != null) {
            this.tempDataName = Deducer.getUniqueName(this.rDataName + Math.random(), guiEnv);
            try {
                Deducer.eval(guiEnv + "$" + this.tempDataName + "<-" + this.rDataName);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
            this.populateArrays();
        }
    }

    public void populateArrays() {
        try {
            this.varNames = Deducer.timedEval("colnames(" + this.rDataName + ")").asStrings();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.varNames == null) {
            this.varNames = new String[0];
        }
        int n = this.varNames.length;
        this.classes = new String[n];
        this.factorLevels = new String[n];
        String[] stringArray = null;
        try {
            stringArray = Deducer.timedEval("sapply(" + this.rDataName + ",function(x){a <- class(x);return(a[length(a)])})").asStrings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.varNames.length; ++i) {
            String string = null;
            if (stringArray != null) {
                string = stringArray[i];
            }
            this.classes[i] = string.equals("Date") ? "Date" : (string.equals("POSIXt") ? "Time" : (string.equals("NULL") ? "NULL" : (string.equals("factor") ? "Factor" : (string.equals("integer") ? "Integer" : (string.equals("character") ? "Character" : (string.equals("logical") ? "Logical" : (string.equals("numeric") ? "Double" : "Other")))))));
            this.factorLevels[i] = "";
            try {
                if (!string.equals("factor")) continue;
                String[] stringArray2 = Deducer.eval("levels(" + this.rDataName + "[," + (i + 1) + "])").asStrings();
                String string2 = "";
                for (int j = 0; j < Math.min(stringArray2.length, 10); ++j) {
                    string2 = string2.concat("(" + (j + 1) + ") ");
                    string2 = string2.concat(stringArray2[j]);
                    string2 = string2.concat("; ");
                }
                if (stringArray2.length > 10) {
                    string2 = string2.concat(" ...");
                }
                this.factorLevels[i] = string2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getColumnCount() {
        return 5;
    }

    public int getRowCount() {
        if (this.varNames != null) {
            return this.varNames.length + 1;
        }
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        try {
            if (n >= this.getRowCount() - 1) {
                return null;
            }
            if (n2 == 0) {
                return this.varNames[n];
            }
            if (n2 == 1) {
                return this.classes[n];
            }
            if (n2 == 2) {
                return this.factorLevels[n];
            }
            return "";
        }
        catch (Exception exception) {
            return "?";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.getRowCount() - 1) {
            if (n2 != 0) return;
            Deducer.timedEval(this.rDataName + "[," + (n + 1) + "]<-NA");
            Deducer.timedEval("colnames(" + this.rDataName + ")[" + (n + 1) + "]<-'" + object.toString().trim() + "'");
            this.refresh();
            this.rowNamesModel.refresh();
            return;
        } else if (n2 == 0) {
            Deducer.eval("{rm(\"" + this.tempDataName + "\",envir=" + guiEnv + ");" + "colnames(" + this.rDataName + ")[" + (n + 1) + "]<-'" + object.toString().trim() + "';" + guiEnv + "$" + this.tempDataName + "<-" + this.rDataName + "}");
            this.varNames[n] = object.toString().trim();
            this.fireTableCellUpdated(n, n2);
            return;
        } else {
            if (n2 != 1) return;
            String string = (String)this.getValueAt(n, n2);
            String string2 = object.toString().toLowerCase().trim();
            if (object.toString().equals(string)) {
                return;
            }
            if (string2.equals("integer")) {
                Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.integer(" + this.rDataName + "[," + (n + 1) + "])");
                this.classes[n] = "Integer";
                this.fireTableCellUpdated(n, n2);
                return;
            } else if (string2.equals("factor")) {
                Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.factor(" + this.rDataName + "[," + (n + 1) + "])");
                this.classes[n] = "Factor";
                this.fireTableCellUpdated(n, n2);
                return;
            } else if (string2.equals("double")) {
                Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.double(" + this.rDataName + "[," + (n + 1) + "])");
                this.classes[n] = "Double";
                this.fireTableCellUpdated(n, n2);
                return;
            } else if (string2.equals("logical")) {
                Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.logical(" + this.rDataName + "[," + (n + 1) + "])");
                this.classes[n] = "Logical";
                this.fireTableCellUpdated(n, n2);
                return;
            } else if (string2.equals("character")) {
                Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.character(" + this.rDataName + "[," + (n + 1) + "])");
                this.classes[n] = "Character";
                this.fireTableCellUpdated(n, n2);
                return;
            } else if (string2.equals("date")) {
                if (string == "Date") {
                    return;
                }
                if (string == "Time") {
                    Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.Date(" + this.rDataName + "[," + (n + 1) + "])");
                    this.refresh();
                    return;
                }
                if (string != "Character" && string != "Factor") {
                    JOptionPane.showMessageDialog(null, "Unable to convert variable of type " + string + " to Date.");
                    return;
                }
                String string3 = "";
                Object[] objectArray = new String[]{"dd/mm/yyyy", "dd-mm-yyyy", "dd/mm/yy", "dd-mm-yy", "mm/dd/yyyy", "mm-dd-yyyy", "mm/dd/yy", "mm-dd-yy", "yyyy/mm/dd", "yyyy-mm-dd", "yy/mm/dd", "yy-mm-dd", "other"};
                Object object2 = JOptionPane.showInputDialog(null, "Choose Date Format", "Date Format", 3, null, objectArray, objectArray[9]);
                if (object2 == null) {
                    return;
                }
                if (object2 == "other") {
                    String string4 = JOptionPane.showInputDialog("Specify a format (e.g. %d %m %Y)");
                    if (string4 == null) {
                        return;
                    }
                    string3 = string4.toString();
                } else if (object2 == objectArray[0]) {
                    string3 = "%d/%m/%Y";
                } else if (object2 == objectArray[1]) {
                    string3 = "%d-%m-%Y";
                } else if (object2 == objectArray[2]) {
                    string3 = "%d/%m/%y";
                } else if (object2 == objectArray[3]) {
                    string3 = "%d-%m-%y";
                } else if (object2 == objectArray[4]) {
                    string3 = "%m/%d/%Y";
                } else if (object2 == objectArray[5]) {
                    string3 = "%m-%d-%Y";
                } else if (object2 == objectArray[6]) {
                    string3 = "%m/%d/%y";
                } else if (object2 == objectArray[7]) {
                    string3 = "%m-%d-%y";
                } else if (object2 == objectArray[8]) {
                    string3 = "%Y/%m/%d";
                } else if (object2 == objectArray[9]) {
                    string3 = "%Y-%m-%d";
                } else if (object2 == objectArray[10]) {
                    string3 = "%y/%m/%d";
                } else if (object2 == objectArray[11]) {
                    string3 = "%y-%m-%d";
                }
                Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.Date(" + this.rDataName + "[," + (n + 1) + "], format= '" + string3 + "')");
                this.classes[n] = "Date";
                this.fireTableCellUpdated(n, n2);
                return;
            } else {
                if (!string2.equals("time")) return;
                if (string == "Date") {
                    Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.POSIXct(" + this.rDataName + "[," + (n + 1) + "])");
                    this.classes[n] = "Time";
                    this.fireTableCellUpdated(n, n2);
                    return;
                }
                if (string == "Time") {
                    return;
                }
                if (string != "Character" && string != "Factor") {
                    JOptionPane.showMessageDialog(null, "Unable to convert variable of type " + string + " to Date.");
                    return;
                }
                String string5 = "";
                Object[] objectArray = new String[]{"dd/mm/yyyy hh:mm:ss", "dd-mm-yyyy hh:mm:ss", "dd/mm/yy hh:mm:ss", "dd-mm-yy hh:mm:ss", "mm/dd/yyyy hh:mm:ss", "mm-dd-yyyy hh:mm:ss", "mm/dd/yy hh:mm:ss", "mm-dd-yy hh:mm:ss", "yyyy/mm/dd hh:mm:ss", "yyyy-mm-dd hh:mm:ss", "yy/mm/dd hh:mm:ss", "yy-mm-dd hh:mm:ss", "other"};
                Object object3 = JOptionPane.showInputDialog(null, "Choose Date/Time Format", "Date/Time Format", 3, null, objectArray, objectArray[9]);
                if (object3 == null) {
                    return;
                }
                if (object3 == "other") {
                    String string6 = JOptionPane.showInputDialog("Specify a format (e.g. %d %m %Y)");
                    if (string6 == null) {
                        return;
                    }
                    string5 = string6.toString();
                } else if (object3 == objectArray[0]) {
                    string5 = "%d/%m/%Y %H:%M:%S";
                } else if (object3 == objectArray[1]) {
                    string5 = "%d-%m-%Y %H:%M:%S";
                } else if (object3 == objectArray[2]) {
                    string5 = "%d/%m/%y %H:%M:%S";
                } else if (object3 == objectArray[3]) {
                    string5 = "%d-%m-%y %H:%M:%S";
                } else if (object3 == objectArray[4]) {
                    string5 = "%m/%d/%Y";
                } else if (object3 == objectArray[5]) {
                    string5 = "%m-%d-%Y %H:%M:%S";
                } else if (object3 == objectArray[6]) {
                    string5 = "%m/%d/%y %H:%M:%S";
                } else if (object3 == objectArray[7]) {
                    string5 = "%m-%d-%y %H:%M:%S";
                } else if (object3 == objectArray[8]) {
                    string5 = "%Y/%m/%d %H:%M:%S";
                } else if (object3 == objectArray[9]) {
                    string5 = "%Y-%m-%d %H:%M:%S";
                } else if (object3 == objectArray[10]) {
                    string5 = "%y/%m/%d %H:%M:%S";
                } else if (object3 == objectArray[11]) {
                    string5 = "%y-%m-%d %H:%M:%S";
                }
                if (string == "Character") {
                    Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.POSIXct(" + this.rDataName + "[," + (n + 1) + "], format='" + string5 + "')");
                    this.classes[n] = "Time";
                    this.fireTableCellUpdated(n, n2);
                    return;
                }
                Deducer.execute(this.rDataName + "[," + (n + 1) + "]<-as.POSIXct(as.character(" + this.rDataName + "[," + (n + 1) + "]), format='" + string5 + "')");
                this.classes[n] = "Time";
                this.fireTableCellUpdated(n, n2);
                return;
            }
        }
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Variable";
        }
        if (n == 1) {
            return "Type";
        }
        if (n == 2) {
            return "Factor Levels";
        }
        return "";
    }

    public boolean refresh() {
        REXP rEXP;
        boolean bl = false;
        REXP rEXP2 = Deducer.eval("!inherits(try(eval(parse(text=\"" + Deducer.addSlashes(this.rDataName) + "\")),silent=TRUE),'try-error')");
        if (rEXP2 != null && ((REXPLogical)rEXP2).isTRUE()[0] && (rEXP = Deducer.eval("identical(" + this.rDataName + "," + guiEnv + "$" + this.tempDataName + ")")) != null && ((REXPLogical)rEXP).isFALSE()[0]) {
            Deducer.eval(guiEnv + "$" + this.tempDataName + "<-" + this.rDataName);
            this.populateArrays();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RDataFrameVariableModel.this.fireTableDataChanged();
                }
            });
            bl = true;
        }
        return bl;
    }

    public void removeCachedData() {
        boolean bl = ((REXPLogical)Deducer.eval("'" + guiEnv + "' %in% .getOtherObjects()")).isTRUE()[0];
        if (!bl) {
            Deducer.eval(guiEnv + "<-new.env(parent=emptyenv())");
        }
        boolean bl2 = false;
        REXP rEXP = Deducer.eval("exists('" + this.tempDataName + "',where=" + guiEnv + ",inherits=FALSE)");
        if (rEXP instanceof REXPLogical) {
            bl2 = ((REXPLogical)rEXP).isTRUE()[0];
        }
        if (bl2) {
            Deducer.eval("rm(" + this.tempDataName + ",envir=" + guiEnv + ")");
        }
    }

    protected void finalize() throws Throwable {
        this.removeCachedData();
        super.finalize();
    }

    public class VariableNumberListModel
    extends RowNamesListModel {
        VariableNumberListModel() {
            RDataFrameVariableModel.this.rowNamesModel = this;
        }

        public Object getElementAt(int n) {
            return new Integer(n + 1);
        }

        public int getSize() {
            return RDataFrameVariableModel.this.varNames.length;
        }
    }
}

