% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HilbertEnvelope.R
\name{HilbertEnvelope}
\alias{HilbertEnvelope}
\title{Instantaneous amplitude}
\usage{
HilbertEnvelope(asig)
}
\arguments{
\item{asig}{The analytic signal returned by \code{\link{HilbertTransform}}}
}
\value{
envelope	Instantaneous amplitude
}
\description{
Generates the instantaneous amplitude of an analytic signal
given by \code{\link{HilbertTransform}}
}
\examples{
tt <- seq(1000) * 0.01
sig <- sin(4 * pi * tt) + sin(3.4 * pi * tt)
asig <- HilbertTransform(sig)
env <- HilbertEnvelope(asig)
plot(tt, sig, type = "l")
lines(tt, env, col = "red")
lines(tt, -env, col = "red")

}
\seealso{
\code{\link{HilbertTransform}}, \code{\link{InstantaneousFrequency}}
}
\author{
Daniel C. Bowman (in the hht package)
}
