% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.pulse.R
\name{as.pulse}
\alias{as.pulse}
\alias{is.pulse}
\title{Create / Check pulse objects}
\usage{
as.pulse(
  dt,
  f,
  a = NULL,
  m = NULL,
  idt = NULL,
  mode = NULL,
  repl = 1,
  order = NA
)

is.pulse(pulse)
}
\arguments{
\item{dt}{a vector of length n for the depth or time reference}

\item{f}{a data.frame or matrix of n rows of the instantaneous frequencies}

\item{a}{a data.frame or matrix of n rows of the instantaneous amplitudes}

\item{m}{a data.frame or matrix of n rows of the components from which the
frequencies and amplitudes were computed from}

\item{idt}{data.frame or matrix of n rows of identity tuning: new dt
coordinates to remove the frequency modulation}

\item{mode}{the mode sequence index to give to each replicated IMFs}

\item{repl}{a vector for the number of replicates or a matrix,
indicating in which replicate set each point is}

\item{order}{the order of the imf, typically from higher frequency to lower
frequency}

\item{pulse}{a pulse object to check}
}
\value{
a list made of $dt (depth/time), $f (instantaneous frequency),
$a (instantaneous amplitude) if a is provided, $repl (the replicate id of
each point) and $mode (the mode id of each point).
}
\description{
Allows to convert instantaneous frequency determination results
into a single 'pulse' object. This is the format generated by inst.pulse
(and gzc if \code{output = 2})
}
\examples{
set.seed(42)

n <- 600
dt <- seq_len(n)

p1 <- 30
p2 <- 240

s30  <- (1 + 0.6 * sin(dt*2*pi/p2)) * sin(dt*2*pi/p1)
s240 <- 2 * sin(dt*2*pi/p2)

xy <- s30 + s240

dec <- as.emd(xy = xy, dt = dt, imf = matrix(c(s30, s240), ncol = 2))

plot_emd(dec, pdf = FALSE, style = 1)

pulse <- inst.pulse(dec, last = TRUE, breaks = 200, bins = 40, cut = 10)

is.pulse(pulse)

simp.pulse <- as.pulse(pulse$dt, pulse$f)

str(simp.pulse)

}
