% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respace.R
\name{respace}
\alias{respace}
\title{Interpolate with even spacing}
\usage{
respace(dt, xy = NULL, delta = NULL, tolerance = 8, relative = TRUE)
}
\arguments{
\item{dt}{depth/time (same length than length/rows of xy)}

\item{xy}{signal (vector or matrix)}

\item{delta}{the new sampling interval. If NA, uses the Greatest Common
Rational Divisor}

\item{tolerance, relative}{parameters for the \code{divisor} function
(\code{StratigrapheR} package), to compute the Greatest Common
Rational Divisor}
}
\value{
a list of interpolated xy and dt values ($xy and $dt), plus a vector
of logicals indicating whether each point was part of the initial input or
was added by interpolation
}
\description{
Interpolate with even spacing. Can determine on its own the
most conservative sampling interval (using the Greatest Common Rational
Divisor)
}
\examples{
set.seed(42)

n <- 50
t <- seq_len(n)

xy <- (1 + 0.6 * sin(t*0.025)) * sin(t*0.2)  + 2 * sin(t*0.025) +
        rnorm(n, sd = 0.5)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5), 1)

dt <- cumsum(inter_dt)

res <- respace(xy = xy, dt = dt)

opar <- par("mfrow")

par(mfrow = c(1,1))

plot(res$xy, res$dt, type = "l")
points(res$xy[res$initial], res$dt[res$initial], pch = 19, col = "green")
points(res$xy[!res$initial], res$dt[!res$initial],
       pch = 19, col = "red", cex = 0.5)

par(mfrow = opar)

}
