% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSinusoidal.R
\name{dataSinusoidal}
\alias{dataSinusoidal}
\title{Generating data from a sinusoidal model with changes}
\usage{
dataSinusoidal(
  n,
  amplitude = 1,
  frequency = 0.001,
  phase = 0,
  sd = 1,
  type = c("none", "up", "updown", "rand1"),
  nbSeg = 20,
  jumpSize = 1
)
}
\arguments{
\item{n}{The length of the sequence of observations.}

\item{amplitude}{The amplitude of the sinusoid}

\item{frequency}{The angular frequency of the sinusoid}

\item{phase}{where the signal starts at time t = 0}

\item{sd}{standard deviation of the noise added on top of the signal}

\item{type}{Possible change scenarios for the jump structure (default: \code{none})}

\item{nbSeg}{Number of segments}

\item{jumpSize}{Maximum magnitude of a change}
}
\value{
A list containing:
\describe{
\item{\code{y}}{the data sequence,}
\item{\code{signal}}{the underlying signal without the noise,}
\item{\code{changepoints}}{the changepoint locations}
}
}
\description{
This function generates a sequence of observation from a sinusoidal model with changes. This can be used as an example 
for model misspecification.
}
\examples{
Y <- dataSinusoidal(
  1e4,
  frequency = 1 / 1e3,
  amplitude = 10,
  type = "updown",
  jumpSize = 4,
  nbSeg = 4
)
res <- DeCAFS(Y$y)
plot(res, col = "grey")
lines(Y$signal, col = "blue", lwd = 2, lty = 2)
abline(v = res$changepoints, col = 2)
abline(v = Y$changepoints, col = 4, lty = 2)
}
