/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.LinkedList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.ColumnCallException;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.BooleanExpressionItem;
import net.starschema.clouddb.jdbc.list.Conjunction;
import net.starschema.clouddb.jdbc.list.Disjunction;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FromExpression;
import net.starschema.clouddb.jdbc.list.GroupByExpression;
import net.starschema.clouddb.jdbc.list.HavingExpression;
import net.starschema.clouddb.jdbc.list.JoinExpression;
import net.starschema.clouddb.jdbc.list.LimitExpression;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.OrderbyExpression;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import net.starschema.clouddb.jdbc.list.WhereExpression;
import net.starschema.clouddb.jdbc.list.WhereExpressionJoinResolver;
import org.antlr.runtime.tree.Tree;

public class SelectStatement
extends Node {
    TreeBuilder builder;
    Expression expression = null;
    FromExpression fromExpression = null;
    WhereExpression whereExpression = null;
    GroupByExpression groupByExpression = null;
    HavingExpression havingExpression = null;
    OrderbyExpression orderByExpression = null;
    LimitExpression limitExpression = null;
    SubQuery parent = null;

    public SubQuery getParent() {
        return this.parent;
    }

    public void setParent(SubQuery parent) {
        this.parent = parent;
    }

    public SelectStatement(Expression expression, FromExpression fromExpression, TreeBuilder treeBuilder) {
        this.builder = treeBuilder;
        this.tokenType = 121;
        this.tokenName = JdbcGrammarParser.tokenNames[this.tokenType];
        this.expression = expression;
        this.fromExpression = fromExpression;
        this.children.addLast(expression);
        this.children.addLast(fromExpression);
    }

    public SelectStatement(Tree t, TreeBuilder treeBuilder) throws TreeParsingException, ColumnCallException {
        this.builder = treeBuilder;
        this.build(t, this.builder);
    }

    public SelectStatement(TreeBuilder builder, Expression expression, FromExpression fromExpression) {
        this.builder = builder;
        this.expression = expression;
        this.fromExpression = fromExpression;
        this.tokenType = 121;
        this.tokenName = JdbcGrammarParser.tokenNames[120];
    }

    public void build(Tree t, TreeBuilder builder) throws TreeParsingException, ColumnCallException {
        if (t.getType() == 121) {
            int i;
            Tree child;
            int i2;
            this.tokenName = JdbcGrammarParser.tokenNames[t.getType()];
            this.logger.debug("BUILDING " + this.tokenName + "which has " + t.getChildCount() + " child");
            this.tokenType = t.getType();
            block20: for (i2 = 0; i2 < t.getChildCount(); ++i2) {
                child = t.getChild(i2);
                switch (child.getType()) {
                    case 50: {
                        this.fromExpression = new FromExpression(child, builder, this);
                        this.children.addLast(this.fromExpression);
                        continue block20;
                    }
                }
            }
            for (i2 = 0; i2 < t.getChildCount(); ++i2) {
                child = t.getChild(i2);
                switch (child.getType()) {
                    case 137: {
                        this.whereExpression = new WhereExpression(child, builder, this);
                    }
                }
            }
            if (this.whereExpression == null && this.fromExpression.children.size() > 1) {
                this.logger.debug("WHEREEXPRESSION WAS NULL");
                LinkedList linkedList = this.fromExpression.children;
                SubQuery left = null;
                for (Node node : linkedList) {
                    if (left == null) {
                        left = (SubQuery)node;
                        continue;
                    }
                    JoinExpression twoSubQIntoJoin = WhereExpressionJoinResolver.mkJoinExprFrmTwoSubQ(left, (SubQuery)node);
                    left = WhereExpressionJoinResolver.mkSubQFromJoinExpr(twoSubQIntoJoin, builder, this);
                }
                this.fromExpression.children = new LinkedList();
                this.fromExpression.children.addLast(left);
            } else if (this.whereExpression != null) {
                this.logger.debug(this.whereExpression.toPrettyString());
                Boolean keepWhere = false;
                switch (this.whereExpression.getExpression().getTokenType()) {
                    case 27: {
                        SubQuery conjunctionAsJoinExpr = WhereExpressionJoinResolver.mkJoinExprFrmConjunction((Conjunction)this.whereExpression.getExpression(), this);
                        if (conjunctionAsJoinExpr != null) {
                            this.fromExpression.children = new LinkedList();
                            this.fromExpression.children.add(conjunctionAsJoinExpr);
                            break;
                        }
                        keepWhere = true;
                        break;
                    }
                    case 13: {
                        SubQuery booleanExprAsJoin = WhereExpressionJoinResolver.mkJoinExprFrmBooleanExprItem((BooleanExpressionItem)this.whereExpression.getExpression(), this);
                        if (booleanExprAsJoin == null) {
                            keepWhere = true;
                            break;
                        }
                        this.fromExpression.children = new LinkedList();
                        this.fromExpression.children.add(booleanExprAsJoin);
                        break;
                    }
                    case 35: {
                        List<SubQuery> disjunctionAsJoin = WhereExpressionJoinResolver.mkJoinExprFrmDisjunction((Disjunction)this.whereExpression.getExpression(), this);
                        this.fromExpression.children = new LinkedList();
                        for (SubQuery subQuery : disjunctionAsJoin) {
                            this.fromExpression.children.add(subQuery);
                        }
                        break;
                    }
                }
                if (!keepWhere.booleanValue()) {
                    this.whereExpression = null;
                }
            }
            block24: for (i = 0; i < t.getChildCount(); ++i) {
                child = t.getChild(i);
                switch (child.getType()) {
                    case 46: {
                        this.logger.debug("BUILDING EXPRESSION");
                        this.expression = new Expression(child, builder, this.fromExpression, this);
                        continue block24;
                    }
                }
            }
            block25: for (i = 0; i < t.getChildCount(); ++i) {
                child = t.getChild(i);
                switch (child.getType()) {
                    case 56: {
                        this.groupByExpression = new GroupByExpression(child, builder, this);
                        this.children.addLast(this.groupByExpression);
                        continue block25;
                    }
                    case 105: {
                        this.orderByExpression = new OrderbyExpression(child, builder, this);
                        this.children.addLast(this.orderByExpression);
                        continue block25;
                    }
                    case 59: {
                        this.havingExpression = new HavingExpression(child, builder, this);
                        this.children.addLast(this.havingExpression);
                        continue block25;
                    }
                    case 83: {
                        this.limitExpression = new LimitExpression(child, builder);
                        this.children.addLast(this.limitExpression);
                        continue block25;
                    }
                }
            }
        } else {
            throw new TreeParsingException("This Tree is not a SELECTSTATEMENT");
        }
    }

    public TreeBuilder getBuilder() {
        return this.builder;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public FromExpression getFromExpression() {
        return this.fromExpression;
    }

    public GroupByExpression getGroupByExpression() {
        return this.groupByExpression;
    }

    public HavingExpression getHavingExpression() {
        return this.havingExpression;
    }

    public LimitExpression getLimitExpression() {
        return this.limitExpression;
    }

    public OrderbyExpression getOrderbyExpression() {
        return this.orderByExpression;
    }

    public WhereExpression getWhereExpression() {
        return this.whereExpression;
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(-1);
    }

    @Override
    public String toPrettyString(int level) {
        String result = "SELECT " + newline + this.tab(level) + this.expression.toPrettyString(level) + this.fromExpression.toPrettyString(level);
        if (this.whereExpression != null) {
            result = result + newline + this.whereExpression.toPrettyString(level);
        }
        if (this.groupByExpression != null) {
            result = result + newline + this.groupByExpression.toPrettyString(level);
        }
        if (this.havingExpression != null) {
            result = result + newline + this.havingExpression.toPrettyString(level);
        }
        if (this.orderByExpression != null) {
            result = result + newline + this.orderByExpression.toPrettyString(level);
        }
        if (this.limitExpression != null) {
            result = result + newline + this.limitExpression.toPrettyString(level);
        }
        return result;
    }
}

