% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbListFields,DatabaseConnectorConnection,character-method}
\alias{dbListFields,DatabaseConnectorConnection,character-method}
\title{List field names of a remote table}
\usage{
\S4method{dbListFields}{DatabaseConnectorConnection,character}(conn, name, databaseSchema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbListFields()}
returns a character vector
that enumerates all fields
in the table in the correct order.
This also works for temporary tables if supported by the database.
The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
}
\description{
Returns the field names of a remote table as a character vector.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbListFields")}
}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.
}
\seealso{
\code{\link[DBI:dbColumnInfo]{dbColumnInfo()}} to get the type of the fields.

Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}
}
