% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbListFields,DatabaseConnectorConnection,character-method}
\alias{dbListFields,DatabaseConnectorConnection,character-method}
\title{List field names of a remote table}
\usage{
\S4method{dbListFields}{DatabaseConnectorConnection,character}(conn, name,
  database = NULL, schema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{a character string with the name of the remote table.}

\item{database}{Name of the database.}

\item{schema}{Name of the schema.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbListFields()}
returns a character vector
that enumerates all fields
in the table in the correct order.
This also works for temporary tables if supported by the database.
The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
If the table does not exist, an error is raised.
Invalid types for the \code{name} argument
(e.g., \code{character} of length not equal to one,
or numeric)
lead to an error.
An error is also raised when calling this method for a closed
or invalid connection.
}
\description{
List field names of a remote table
}
\seealso{
\code{\link[=dbColumnInfo]{dbColumnInfo()}} to get the type of the fields.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbAppendTable}}, \code{\link{dbCreateTable}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbListObjects}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}},
  \code{\link{dbWriteTable}}
}
