% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_dat_col.R
\name{simulation_methods_date}
\alias{simulation_methods_date}
\alias{simul_spec_date_distr}
\alias{simul_default_date}
\alias{simul_restricted_date_range}
\alias{simul_restricted_date_fkey}
\title{Date type simulation methods}
\usage{
simul_spec_date_distr(
  n,
  not_null,
  unique,
  default,
  spec_params,
  na_ratio,
  levels_ratio,
  ...
)

simul_default_date(
  n,
  not_null,
  unique,
  default,
  type,
  min_date,
  max_date,
  format,
  na_ratio,
  levels_ratio,
  ...
)

simul_restricted_date_range(
  n,
  not_null,
  unique,
  default,
  type,
  range,
  format,
  na_ratio,
  levels_ratio,
  ...
)

simul_restricted_date_fkey(
  n,
  not_null,
  unique,
  default,
  type,
  values,
  na_ratio,
  levels_ratio,
  ...
)
}
\arguments{
\item{n}{Number of values to simulate.}

\item{not_null}{Should NA values be forbidden?}

\item{unique}{Should duplicated values be allowed?}

\item{default}{Default column value.}

\item{spec_params}{Set of parameters passed to special method.}

\item{na_ratio}{Ratio of NA values (in terms of sample length) the sample should have.}

\item{levels_ratio}{Fraction of levels (in terms of sample length) the sample should have.}

\item{...}{Other parameters passed to column configuration in YAML file.}

\item{type}{Column raw type (sourced from configuration file).}

\item{format}{Date format used to store dates.}

\item{range, min_date, max_date}{Date range or minimum and maximum date from which to simulate data.}

\item{values}{Possible values from which to perform simulation.}
}
\description{
Date type simulation methods
}
